/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.IRecipeComplex;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;

public class RecipeTippedArrow
extends IRecipeComplex {
    public RecipeTippedArrow(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, World var1) {
        if (var0.width() != 3 || var0.height() != 3 || var0.ingredientCount() != 9) {
            return false;
        }
        for (int var2 = 0; var2 < var0.height(); ++var2) {
            for (int var3 = 0; var3 < var0.width(); ++var3) {
                ItemStack var4 = var0.getItem(var3, var2);
                if (var4.isEmpty()) {
                    return false;
                }
                if (!(var3 == 1 && var2 == 1 ? !var4.is(Items.LINGERING_POTION) : !var4.is(Items.ARROW))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.a var1) {
        ItemStack var2 = var0.getItem(1, 1);
        if (!var2.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack var3 = new ItemStack(Items.TIPPED_ARROW, 8);
        var3.set(DataComponents.POTION_CONTENTS, var2.get(DataComponents.POTION_CONTENTS));
        return var3;
    }

    @Override
    public RecipeSerializer<RecipeTippedArrow> getSerializer() {
        return RecipeSerializer.TIPPED_ARROW;
    }
}

