/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public record KineticWeapon(int contactCooldownTicks, int delayTicks, Optional<a> dismountConditions, Optional<a> knockbackConditions, Optional<a> damageConditions, float forwardMovement, float damageMultiplier, Optional<Holder<SoundEffect>> sound, Optional<Holder<SoundEffect>> hitSound) {
    public static final int HIT_FEEDBACK_TICKS = 10;
    public static final Codec<KineticWeapon> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::contactCooldownTicks), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::delayTicks), (App)a.CODEC.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::dismountConditions), (App)a.CODEC.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::knockbackConditions), (App)a.CODEC.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::damageConditions), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::forwardMovement), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::damageMultiplier), (App)SoundEffect.CODEC.optionalFieldOf("sound").forGetter(KineticWeapon::sound), (App)SoundEffect.CODEC.optionalFieldOf("hit_sound").forGetter(KineticWeapon::hitSound)).apply((Applicative)var0, KineticWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, KineticWeapon::contactCooldownTicks, ByteBufCodecs.VAR_INT, KineticWeapon::delayTicks, a.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::dismountConditions, a.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::knockbackConditions, a.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::damageConditions, ByteBufCodecs.FLOAT, KineticWeapon::forwardMovement, ByteBufCodecs.FLOAT, KineticWeapon::damageMultiplier, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::sound, SoundEffect.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::hitSound, KineticWeapon::new);

    public static Vec3D getMotion(Entity var0) {
        if (!(var0 instanceof EntityHuman) && var0.isPassenger()) {
            var0 = var0.getRootVehicle();
        }
        return var0.getKnownSpeed().scale(20.0);
    }

    public void makeSound(Entity var0) {
        this.sound.ifPresent(var1 -> var0.level().playSound(var0, var0.getX(), var0.getY(), var0.getZ(), (Holder<SoundEffect>)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeLocalHitSound(Entity var0) {
        this.hitSound.ifPresent(var1 -> var0.level().playLocalSound(var0, (SoundEffect)var1.value(), var0.getSoundSource(), 1.0f, 1.0f));
    }

    public int computeDamageUseDuration() {
        return this.delayTicks + this.damageConditions.map(a::maxDurationTicks).orElse(0);
    }

    public void damageEntities(ItemStack var02, int var12, EntityLiving var2, EnumItemSlot var3) {
        int var4 = var02.getUseDuration(var2) - var12;
        if (var4 < this.delayTicks) {
            return;
        }
        var4 -= this.delayTicks;
        Vec3D var5 = var2.getLookAngle();
        double var6 = var5.dot(KineticWeapon.getMotion(var2));
        float var8 = var2 instanceof EntityHuman ? 1.0f : 0.2f;
        AttackRange var9 = var2.entityAttackRange();
        double var10 = var2.getAttributeBaseValue(GenericAttributes.ATTACK_DAMAGE);
        boolean var122 = false;
        for (MovingObjectPositionEntity var14 : (Collection)ProjectileHelper.getHitEntitiesAlong(var2, var9, var1 -> PiercingWeapon.canHitEntity(var2, var1), RayTrace.BlockCollisionOption.COLLIDER).map(var0 -> List.of(), var0 -> var0)) {
            boolean var23;
            boolean var16;
            Entity var15 = var14.getEntity();
            if (var15 instanceof EntityComplexPart) {
                EntityComplexPart var162 = (EntityComplexPart)var15;
                var15 = var162.parentMob;
            }
            if (var16 = var2.wasRecentlyStabbed(var15, this.contactCooldownTicks)) continue;
            var2.rememberStabbedEntity(var15);
            double var17 = var5.dot(KineticWeapon.getMotion(var15));
            double var19 = Math.max(0.0, var6 - var17);
            boolean var21 = this.dismountConditions.isPresent() && this.dismountConditions.get().test(var4, var6, var19, var8);
            boolean var22 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().test(var4, var6, var19, var8);
            boolean bl = var23 = this.damageConditions.isPresent() && this.damageConditions.get().test(var4, var6, var19, var8);
            if (!var21 && !var22 && !var23) continue;
            float var24 = (float)var10 + (float)MathHelper.floor(var19 * (double)this.damageMultiplier);
            var122 |= var2.stabAttack(var3, var15, var24, var23, var22, var21);
        }
        if (var122) {
            var2.level().broadcastEntityEvent(var2, (byte)2);
            if (var2 instanceof EntityPlayer) {
                EntityPlayer var13 = (EntityPlayer)var2;
                CriterionTriggers.SPEAR_MOBS_TRIGGER.trigger(var13, var2.stabbedEntities(var0 -> var0 instanceof EntityLiving));
            }
        }
    }

    public record a(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_duration_ticks").forGetter(a::maxDurationTicks), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(a::minSpeed), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(a::minRelativeSpeed)).apply((Applicative)var0, a::new));
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, a::maxDurationTicks, ByteBufCodecs.FLOAT, a::minSpeed, ByteBufCodecs.FLOAT, a::minRelativeSpeed, a::new);

        public boolean test(int var0, double var1, double var3, double var5) {
            return var0 <= this.maxDurationTicks && var1 >= (double)this.minSpeed * var5 && var3 >= (double)this.minRelativeSpeed * var5;
        }

        public static Optional<a> ofAttackerSpeed(int var0, float var1) {
            return Optional.of(new a(var0, var1, 0.0f));
        }

        public static Optional<a> ofRelativeSpeed(int var0, float var1) {
            return Optional.of(new a(var0, 0.0f, var1));
        }
    }
}

