/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import org.jspecify.annotations.Nullable;

public class MobBucketItem
extends ItemBucket {
    private final EntityTypes<? extends EntityInsentient> type;
    private final SoundEffect emptySound;

    public MobBucketItem(EntityTypes<? extends EntityInsentient> var0, FluidType var1, SoundEffect var2, Item.Info var3) {
        super(var1, var3);
        this.type = var0;
        this.emptySound = var2;
    }

    @Override
    public void checkExtraContent(@Nullable EntityLiving var0, World var1, ItemStack var2, BlockPosition var3) {
        if (var1 instanceof WorldServer) {
            this.spawn((WorldServer)var1, var2, var3);
            var1.gameEvent((Entity)var0, GameEvent.ENTITY_PLACE, var3);
        }
    }

    @Override
    protected void playEmptySound(@Nullable EntityLiving var0, GeneratorAccess var1, BlockPosition var2) {
        var1.playSound(var0, var2, this.emptySound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void spawn(WorldServer var0, ItemStack var1, BlockPosition var2) {
        EntityInsentient var3 = this.type.create(var0, EntityTypes.createDefaultStackConfig(var0, var1, null), var2, EntitySpawnReason.BUCKET, true, false);
        if (var3 instanceof Bucketable) {
            Bucketable var4 = (Bucketable)((Object)var3);
            CustomData var5 = var1.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, CustomData.EMPTY);
            var4.loadFromBucketTag(var5.copyTag());
            var4.setFromBucket(true);
        }
        if (var3 != null) {
            var0.addFreshEntityWithPassengers(var3);
            var3.playAmbientSound();
        }
    }
}

