/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class ItemBoat
extends Item {
    private final EntityTypes<? extends AbstractBoat> entityType;

    public ItemBoat(EntityTypes<? extends AbstractBoat> var0, Item.Info var1) {
        super(var1);
        this.entityType = var0;
    }

    @Override
    public EnumInteractionResult use(World var0, EntityHuman var1, EnumHand var2) {
        Object var9;
        ItemStack var3 = var1.getItemInHand(var2);
        MovingObjectPositionBlock var4 = ItemBoat.getPlayerPOVHitResult(var0, var1, RayTrace.FluidCollisionOption.ANY);
        if (((MovingObjectPosition)var4).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            return EnumInteractionResult.PASS;
        }
        Vec3D var5 = var1.getViewVector(1.0f);
        double var6 = 5.0;
        List<Entity> var8 = var0.getEntities(var1, var1.getBoundingBox().expandTowards(var5.scale(5.0)).inflate(1.0), IEntitySelector.CAN_BE_PICKED);
        if (!var8.isEmpty()) {
            var9 = var1.getEyePosition();
            for (Entity var11 : var8) {
                AxisAlignedBB var12 = var11.getBoundingBox().inflate(var11.getPickRadius());
                if (!var12.contains((Vec3D)var9)) continue;
                return EnumInteractionResult.PASS;
            }
        }
        if (((MovingObjectPosition)var4).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) {
            var9 = this.getBoat(var0, var4, var3, var1);
            if (var9 == null) {
                return EnumInteractionResult.FAIL;
            }
            ((Entity)var9).setYRot(var1.getYRot());
            if (!var0.noCollision((Entity)var9, ((Entity)var9).getBoundingBox())) {
                return EnumInteractionResult.FAIL;
            }
            if (!var0.isClientSide()) {
                var0.addFreshEntity((Entity)var9);
                var0.gameEvent((Entity)var1, GameEvent.ENTITY_PLACE, var4.getLocation());
                var3.consume(1, var1);
            }
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    private @Nullable AbstractBoat getBoat(World var0, MovingObjectPosition var1, ItemStack var2, EntityHuman var3) {
        AbstractBoat var4 = this.entityType.create(var0, EntitySpawnReason.SPAWN_ITEM_USE);
        if (var4 != null) {
            Vec3D var5 = var1.getLocation();
            var4.setInitialPos(var5.x, var5.y, var5.z);
            if (var0 instanceof WorldServer) {
                WorldServer var6 = (WorldServer)var0;
                EntityTypes.createDefaultStackConfig(var6, var2, var3).accept(var4);
            }
        }
        return var4;
    }
}

