/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;

public class HoneycombItem
extends Item
implements SignApplicator {
    public static final Supplier<BiMap<Block, Block>> WAXABLES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)Blocks.COPPER_BLOCK, (Object)Blocks.WAXED_COPPER_BLOCK).put((Object)Blocks.EXPOSED_COPPER, (Object)Blocks.WAXED_EXPOSED_COPPER).put((Object)Blocks.WEATHERED_COPPER, (Object)Blocks.WAXED_WEATHERED_COPPER).put((Object)Blocks.OXIDIZED_COPPER, (Object)Blocks.WAXED_OXIDIZED_COPPER).put((Object)Blocks.CUT_COPPER, (Object)Blocks.WAXED_CUT_COPPER).put((Object)Blocks.EXPOSED_CUT_COPPER, (Object)Blocks.WAXED_EXPOSED_CUT_COPPER).put((Object)Blocks.WEATHERED_CUT_COPPER, (Object)Blocks.WAXED_WEATHERED_CUT_COPPER).put((Object)Blocks.OXIDIZED_CUT_COPPER, (Object)Blocks.WAXED_OXIDIZED_CUT_COPPER).put((Object)Blocks.CUT_COPPER_SLAB, (Object)Blocks.WAXED_CUT_COPPER_SLAB).put((Object)Blocks.EXPOSED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_EXPOSED_CUT_COPPER_SLAB).put((Object)Blocks.WEATHERED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_WEATHERED_CUT_COPPER_SLAB).put((Object)Blocks.OXIDIZED_CUT_COPPER_SLAB, (Object)Blocks.WAXED_OXIDIZED_CUT_COPPER_SLAB).put((Object)Blocks.CUT_COPPER_STAIRS, (Object)Blocks.WAXED_CUT_COPPER_STAIRS).put((Object)Blocks.EXPOSED_CUT_COPPER_STAIRS, (Object)Blocks.WAXED_EXPOSED_CUT_COPPER_STAIRS).put((Object)Blocks.WEATHERED_CUT_COPPER_STAIRS, (Object)Blocks.WAXED_WEATHERED_CUT_COPPER_STAIRS).put((Object)Blocks.OXIDIZED_CUT_COPPER_STAIRS, (Object)Blocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS).put((Object)Blocks.CHISELED_COPPER, (Object)Blocks.WAXED_CHISELED_COPPER).put((Object)Blocks.EXPOSED_CHISELED_COPPER, (Object)Blocks.WAXED_EXPOSED_CHISELED_COPPER).put((Object)Blocks.WEATHERED_CHISELED_COPPER, (Object)Blocks.WAXED_WEATHERED_CHISELED_COPPER).put((Object)Blocks.OXIDIZED_CHISELED_COPPER, (Object)Blocks.WAXED_OXIDIZED_CHISELED_COPPER).put((Object)Blocks.COPPER_DOOR, (Object)Blocks.WAXED_COPPER_DOOR).put((Object)Blocks.EXPOSED_COPPER_DOOR, (Object)Blocks.WAXED_EXPOSED_COPPER_DOOR).put((Object)Blocks.WEATHERED_COPPER_DOOR, (Object)Blocks.WAXED_WEATHERED_COPPER_DOOR).put((Object)Blocks.OXIDIZED_COPPER_DOOR, (Object)Blocks.WAXED_OXIDIZED_COPPER_DOOR).put((Object)Blocks.COPPER_TRAPDOOR, (Object)Blocks.WAXED_COPPER_TRAPDOOR).put((Object)Blocks.EXPOSED_COPPER_TRAPDOOR, (Object)Blocks.WAXED_EXPOSED_COPPER_TRAPDOOR).put((Object)Blocks.WEATHERED_COPPER_TRAPDOOR, (Object)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR).put((Object)Blocks.OXIDIZED_COPPER_TRAPDOOR, (Object)Blocks.WAXED_OXIDIZED_COPPER_TRAPDOOR).putAll(Blocks.COPPER_BARS.waxedMapping()).put((Object)Blocks.COPPER_GRATE, (Object)Blocks.WAXED_COPPER_GRATE).put((Object)Blocks.EXPOSED_COPPER_GRATE, (Object)Blocks.WAXED_EXPOSED_COPPER_GRATE).put((Object)Blocks.WEATHERED_COPPER_GRATE, (Object)Blocks.WAXED_WEATHERED_COPPER_GRATE).put((Object)Blocks.OXIDIZED_COPPER_GRATE, (Object)Blocks.WAXED_OXIDIZED_COPPER_GRATE).put((Object)Blocks.COPPER_BULB, (Object)Blocks.WAXED_COPPER_BULB).put((Object)Blocks.EXPOSED_COPPER_BULB, (Object)Blocks.WAXED_EXPOSED_COPPER_BULB).put((Object)Blocks.WEATHERED_COPPER_BULB, (Object)Blocks.WAXED_WEATHERED_COPPER_BULB).put((Object)Blocks.OXIDIZED_COPPER_BULB, (Object)Blocks.WAXED_OXIDIZED_COPPER_BULB).put((Object)Blocks.COPPER_CHEST, (Object)Blocks.WAXED_COPPER_CHEST).put((Object)Blocks.EXPOSED_COPPER_CHEST, (Object)Blocks.WAXED_EXPOSED_COPPER_CHEST).put((Object)Blocks.WEATHERED_COPPER_CHEST, (Object)Blocks.WAXED_WEATHERED_COPPER_CHEST).put((Object)Blocks.OXIDIZED_COPPER_CHEST, (Object)Blocks.WAXED_OXIDIZED_COPPER_CHEST).put((Object)Blocks.COPPER_GOLEM_STATUE, (Object)Blocks.WAXED_COPPER_GOLEM_STATUE).put((Object)Blocks.EXPOSED_COPPER_GOLEM_STATUE, (Object)Blocks.WAXED_EXPOSED_COPPER_GOLEM_STATUE).put((Object)Blocks.WEATHERED_COPPER_GOLEM_STATUE, (Object)Blocks.WAXED_WEATHERED_COPPER_GOLEM_STATUE).put((Object)Blocks.OXIDIZED_COPPER_GOLEM_STATUE, (Object)Blocks.WAXED_OXIDIZED_COPPER_GOLEM_STATUE).put((Object)Blocks.LIGHTNING_ROD, (Object)Blocks.WAXED_LIGHTNING_ROD).put((Object)Blocks.EXPOSED_LIGHTNING_ROD, (Object)Blocks.WAXED_EXPOSED_LIGHTNING_ROD).put((Object)Blocks.WEATHERED_LIGHTNING_ROD, (Object)Blocks.WAXED_WEATHERED_LIGHTNING_ROD).put((Object)Blocks.OXIDIZED_LIGHTNING_ROD, (Object)Blocks.WAXED_OXIDIZED_LIGHTNING_ROD).putAll(Blocks.COPPER_LANTERN.waxedMapping()).putAll(Blocks.COPPER_CHAIN.waxedMapping()).build());
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.get().inverse());
    private static final String WAXED_COPPER_DOOR = "waxed_copper_door";
    private static final String WAXED_COPPER_TRAPDOOR = "waxed_copper_trapdoor";
    private static final String WAXED_COPPER_GOLEM_STATUE = "waxed_copper_golem_statue";
    private static final String WAXED_COPPER_CHEST = "waxed_copper_chest";
    private static final String WAXED_LIGHTNING_ROD = "waxed_lightning_rod";
    private static final String WAXED_COPPER_BAR = "waxed_copper_bar";
    private static final String WAXED_COPPER_CHAIN = "waxed_copper_chain";
    private static final String WAXED_COPPER_LANTERN = "waxed_copper_lantern";
    private static final String WAXED_COPPER_BLOCK = "waxed_copper_block";
    public static final ImmutableMap<Block, Pair<RecipeCategory, String>> WAXED_RECIPES = ImmutableMap.builder().put((Object)Blocks.WAXED_COPPER_BULB, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_bulb")).put((Object)Blocks.WAXED_WEATHERED_COPPER_BULB, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_weathered_copper_bulb")).put((Object)Blocks.WAXED_EXPOSED_COPPER_BULB, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_exposed_copper_bulb")).put((Object)Blocks.WAXED_OXIDIZED_COPPER_BULB, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_oxidized_copper_bulb")).put((Object)Blocks.WAXED_COPPER_DOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_door")).put((Object)Blocks.WAXED_WEATHERED_COPPER_DOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_door")).put((Object)Blocks.WAXED_EXPOSED_COPPER_DOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_door")).put((Object)Blocks.WAXED_OXIDIZED_COPPER_DOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_door")).put((Object)Blocks.WAXED_COPPER_TRAPDOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_trapdoor")).put((Object)Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_trapdoor")).put((Object)Blocks.WAXED_EXPOSED_COPPER_TRAPDOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_trapdoor")).put((Object)Blocks.WAXED_OXIDIZED_COPPER_TRAPDOOR, (Object)Pair.of((Object)((Object)RecipeCategory.REDSTONE), (Object)"waxed_copper_trapdoor")).put((Object)Blocks.WAXED_COPPER_GOLEM_STATUE, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_golem_statue")).put((Object)Blocks.WAXED_WEATHERED_COPPER_GOLEM_STATUE, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_golem_statue")).put((Object)Blocks.WAXED_EXPOSED_COPPER_GOLEM_STATUE, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_golem_statue")).put((Object)Blocks.WAXED_OXIDIZED_COPPER_GOLEM_STATUE, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_golem_statue")).put((Object)Blocks.WAXED_COPPER_CHEST, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chest")).put((Object)Blocks.WAXED_WEATHERED_COPPER_CHEST, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chest")).put((Object)Blocks.WAXED_EXPOSED_COPPER_CHEST, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chest")).put((Object)Blocks.WAXED_OXIDIZED_COPPER_CHEST, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chest")).put((Object)Blocks.WAXED_LIGHTNING_ROD, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_lightning_rod")).put((Object)Blocks.WAXED_WEATHERED_LIGHTNING_ROD, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_lightning_rod")).put((Object)Blocks.WAXED_EXPOSED_LIGHTNING_ROD, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_lightning_rod")).put((Object)Blocks.WAXED_OXIDIZED_LIGHTNING_ROD, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_lightning_rod")).put((Object)Blocks.COPPER_BARS.waxed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_bar")).put((Object)Blocks.COPPER_BARS.waxedWeathered(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_bar")).put((Object)Blocks.COPPER_BARS.waxedExposed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_bar")).put((Object)Blocks.COPPER_BARS.waxedOxidized(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_bar")).put((Object)Blocks.COPPER_CHAIN.waxed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chain")).put((Object)Blocks.COPPER_CHAIN.waxedWeathered(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chain")).put((Object)Blocks.COPPER_CHAIN.waxedExposed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chain")).put((Object)Blocks.COPPER_CHAIN.waxedOxidized(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_chain")).put((Object)Blocks.COPPER_LANTERN.waxed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_lantern")).put((Object)Blocks.COPPER_LANTERN.waxedWeathered(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_lantern")).put((Object)Blocks.COPPER_LANTERN.waxedExposed(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_lantern")).put((Object)Blocks.COPPER_LANTERN.waxedOxidized(), (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_lantern")).put((Object)Blocks.WAXED_COPPER_BLOCK, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_block")).put((Object)Blocks.WAXED_WEATHERED_COPPER, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_block")).put((Object)Blocks.WAXED_EXPOSED_COPPER, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_block")).put((Object)Blocks.WAXED_OXIDIZED_COPPER, (Object)Pair.of((Object)((Object)RecipeCategory.BUILDING_BLOCKS), (Object)"waxed_copper_block")).build();

    public HoneycombItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        IBlockData var3 = var1.getBlockState(var2);
        return HoneycombItem.getWaxed(var3).map(var4 -> {
            Object var7;
            EntityHuman var5 = var0.getPlayer();
            ItemStack var6 = var0.getItemInHand();
            if (var5 instanceof EntityPlayer) {
                var7 = (EntityPlayer)var5;
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger((EntityPlayer)var7, var2, var6);
            }
            var6.shrink(1);
            var1.setBlock(var2, (IBlockData)var4, 11);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var5, var4));
            var1.levelEvent(var5, 3003, var2, 0);
            if (var3.getBlock() instanceof BlockChest && var3.getValue(BlockChest.TYPE) != BlockPropertyChestType.SINGLE) {
                var7 = BlockChest.getConnectedBlockPos(var2, var3);
                var1.gameEvent(GameEvent.BLOCK_CHANGE, (BlockPosition)var7, GameEvent.a.of(var5, var1.getBlockState((BlockPosition)var7)));
                var1.levelEvent(var5, 3003, (BlockPosition)var7, 0);
            }
            return EnumInteractionResult.SUCCESS;
        }).orElse(EnumInteractionResult.PASS);
    }

    public static Optional<IBlockData> getWaxed(IBlockData var0) {
        return Optional.ofNullable((Block)WAXABLES.get().get((Object)var0.getBlock())).map(var1 -> var1.withPropertiesOf(var0));
    }

    @Override
    public boolean tryApplyToSign(World var0, TileEntitySign var1, boolean var2, EntityHuman var3) {
        if (var1.setWaxed(true)) {
            var0.levelEvent(null, 3003, var1.getBlockPos(), 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean canApplyToSign(SignText var0, EntityHuman var1) {
        return true;
    }
}

