/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.material.MaterialMapColor;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public final class EnumColor
extends Enum<EnumColor>
implements INamable {
    public static final /* enum */ EnumColor WHITE = new EnumColor(0, "white", 0xF9FFFE, MaterialMapColor.SNOW, 0xF0F0F0, 0xFFFFFF);
    public static final /* enum */ EnumColor ORANGE = new EnumColor(1, "orange", 16351261, MaterialMapColor.COLOR_ORANGE, 15435844, 16738335);
    public static final /* enum */ EnumColor MAGENTA = new EnumColor(2, "magenta", 13061821, MaterialMapColor.COLOR_MAGENTA, 12801229, 0xFF00FF);
    public static final /* enum */ EnumColor LIGHT_BLUE = new EnumColor(3, "light_blue", 3847130, MaterialMapColor.COLOR_LIGHT_BLUE, 6719955, 10141901);
    public static final /* enum */ EnumColor YELLOW = new EnumColor(4, "yellow", 16701501, MaterialMapColor.COLOR_YELLOW, 14602026, 0xFFFF00);
    public static final /* enum */ EnumColor LIME = new EnumColor(5, "lime", 8439583, MaterialMapColor.COLOR_LIGHT_GREEN, 4312372, 0xBFFF00);
    public static final /* enum */ EnumColor PINK = new EnumColor(6, "pink", 15961002, MaterialMapColor.COLOR_PINK, 14188952, 16738740);
    public static final /* enum */ EnumColor GRAY = new EnumColor(7, "gray", 4673362, MaterialMapColor.COLOR_GRAY, 0x434343, 0x808080);
    public static final /* enum */ EnumColor LIGHT_GRAY = new EnumColor(8, "light_gray", 0x9D9D97, MaterialMapColor.COLOR_LIGHT_GRAY, 0xABABAB, 0xD3D3D3);
    public static final /* enum */ EnumColor CYAN = new EnumColor(9, "cyan", 1481884, MaterialMapColor.COLOR_CYAN, 2651799, 65535);
    public static final /* enum */ EnumColor PURPLE = new EnumColor(10, "purple", 8991416, MaterialMapColor.COLOR_PURPLE, 8073150, 10494192);
    public static final /* enum */ EnumColor BLUE = new EnumColor(11, "blue", 3949738, MaterialMapColor.COLOR_BLUE, 2437522, 255);
    public static final /* enum */ EnumColor BROWN = new EnumColor(12, "brown", 8606770, MaterialMapColor.COLOR_BROWN, 5320730, 9127187);
    public static final /* enum */ EnumColor GREEN = new EnumColor(13, "green", 6192150, MaterialMapColor.COLOR_GREEN, 3887386, 65280);
    public static final /* enum */ EnumColor RED = new EnumColor(14, "red", 11546150, MaterialMapColor.COLOR_RED, 11743532, 0xFF0000);
    public static final /* enum */ EnumColor BLACK = new EnumColor(15, "black", 0x1D1D21, MaterialMapColor.COLOR_BLACK, 0x1E1B1B, 0);
    private static final IntFunction<EnumColor> BY_ID;
    private static final Int2ObjectOpenHashMap<EnumColor> BY_FIREWORK_COLOR;
    public static final INamable.a<EnumColor> CODEC;
    public static final StreamCodec<ByteBuf, EnumColor> STREAM_CODEC;
    @Deprecated
    public static final Codec<EnumColor> LEGACY_ID_CODEC;
    private final int id;
    private final String name;
    private final MaterialMapColor mapColor;
    private final int textureDiffuseColor;
    private final int fireworkColor;
    private final int textColor;
    private static final /* synthetic */ EnumColor[] B;

    public static EnumColor[] values() {
        return (EnumColor[])B.clone();
    }

    public static EnumColor valueOf(String var0) {
        return Enum.valueOf(EnumColor.class, var0);
    }

    private EnumColor(int var2, String var3, int var4, MaterialMapColor var5, int var6, int var7) {
        this.id = var2;
        this.name = var3;
        this.mapColor = var5;
        this.textColor = ARGB.opaque(var7);
        this.textureDiffuseColor = ARGB.opaque(var4);
        this.fireworkColor = var6;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getTextureDiffuseColor() {
        return this.textureDiffuseColor;
    }

    public MaterialMapColor getMapColor() {
        return this.mapColor;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static EnumColor byId(int var0) {
        return BY_ID.apply(var0);
    }

    @Contract(value="_,!null->!null;_,null->_")
    public static @Nullable EnumColor byName(String var0, @Nullable EnumColor var1) {
        EnumColor var2 = CODEC.byName(var0);
        return var2 != null ? var2 : var1;
    }

    public static @Nullable EnumColor byFireworkColor(int var0) {
        return (EnumColor)BY_FIREWORK_COLOR.get(var0);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public static EnumColor getMixedColor(WorldServer var0, EnumColor var1, EnumColor var22) {
        CraftingInput var3 = EnumColor.makeCraftColorInput(var1, var22);
        return var0.recipeAccess().getRecipeFor(Recipes.CRAFTING, var3, var0).map(var2 -> ((RecipeCrafting)var2.value()).assemble(var3, var0.registryAccess())).map(ItemStack::getItem).filter(ItemDye.class::isInstance).map(ItemDye.class::cast).map(ItemDye::getDyeColor).orElseGet(() -> var0.random.nextBoolean() ? var1 : var22);
    }

    private static CraftingInput makeCraftColorInput(EnumColor var0, EnumColor var1) {
        return CraftingInput.of(2, 1, List.of(new ItemStack(ItemDye.byColor(var0)), new ItemStack(ItemDye.byColor(var1))));
    }

    private static /* synthetic */ EnumColor[] h() {
        return new EnumColor[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
    }

    static {
        B = EnumColor.h();
        BY_ID = ByIdMap.continuous(EnumColor::getId, EnumColor.values(), ByIdMap.a.ZERO);
        BY_FIREWORK_COLOR = new Int2ObjectOpenHashMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(var0 -> var0.fireworkColor, var0 -> var0)));
        CODEC = INamable.fromEnum(EnumColor::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, EnumColor::getId);
        LEGACY_ID_CODEC = Codec.BYTE.xmap(EnumColor::byId, var0 -> (byte)var0.id);
    }
}

