/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.IMaterial;
import org.jspecify.annotations.Nullable;

public class CreativeModeTab {
    static final MinecraftKey DEFAULT_BACKGROUND = CreativeModeTab.createTextureLocation("items");
    private final IChatBaseComponent displayName;
    MinecraftKey backgroundTexture = DEFAULT_BACKGROUND;
    boolean canScroll = true;
    boolean showTitle = true;
    boolean alignedRight = false;
    private final f row;
    private final int column;
    private final h type;
    private @Nullable ItemStack iconItemStack;
    private Collection<ItemStack> displayItems = ItemStackLinkedSet.createTypeAndComponentsSet();
    private Set<ItemStack> displayItemsSearchTab = ItemStackLinkedSet.createTypeAndComponentsSet();
    private final Supplier<ItemStack> iconGenerator;
    private final b displayItemsGenerator;

    CreativeModeTab(f var0, int var1, h var2, IChatBaseComponent var3, Supplier<ItemStack> var4, b var5) {
        this.row = var0;
        this.column = var1;
        this.displayName = var3;
        this.iconGenerator = var4;
        this.displayItemsGenerator = var5;
        this.type = var2;
    }

    public static MinecraftKey createTextureLocation(String var0) {
        return MinecraftKey.withDefaultNamespace("textures/gui/container/creative_inventory/tab_" + var0 + ".png");
    }

    public static a builder(f var0, int var1) {
        return new a(var0, var1);
    }

    public IChatBaseComponent getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIconItem() {
        if (this.iconItemStack == null) {
            this.iconItemStack = this.iconGenerator.get();
        }
        return this.iconItemStack;
    }

    public MinecraftKey getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public boolean canScroll() {
        return this.canScroll;
    }

    public int column() {
        return this.column;
    }

    public f row() {
        return this.row;
    }

    public boolean hasAnyItems() {
        return !this.displayItems.isEmpty();
    }

    public boolean shouldDisplay() {
        return this.type != h.CATEGORY || this.hasAnyItems();
    }

    public boolean isAlignedRight() {
        return this.alignedRight;
    }

    public h getType() {
        return this.type;
    }

    public void buildContents(d var0) {
        c var1 = new c(this, var0.enabledFeatures);
        ResourceKey<CreativeModeTab> var2 = BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey(this).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + String.valueOf(this)));
        this.displayItemsGenerator.accept(var0, var1);
        this.displayItems = var1.tabContents;
        this.displayItemsSearchTab = var1.searchTabContents;
    }

    public Collection<ItemStack> getDisplayItems() {
        return this.displayItems;
    }

    public Collection<ItemStack> getSearchTabDisplayItems() {
        return this.displayItemsSearchTab;
    }

    public boolean contains(ItemStack var0) {
        return this.displayItemsSearchTab.contains(var0);
    }

    public static final class f
    extends Enum<f> {
        public static final /* enum */ f TOP = new f();
        public static final /* enum */ f BOTTOM = new f();
        private static final /* synthetic */ f[] c;

        public static f[] values() {
            return (f[])c.clone();
        }

        public static f valueOf(String var0) {
            return Enum.valueOf(f.class, var0);
        }

        private static /* synthetic */ f[] a() {
            return new f[]{TOP, BOTTOM};
        }

        static {
            c = f.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(d var1, e var2);
    }

    public static final class h
    extends Enum<h> {
        public static final /* enum */ h CATEGORY = new h();
        public static final /* enum */ h INVENTORY = new h();
        public static final /* enum */ h HOTBAR = new h();
        public static final /* enum */ h SEARCH = new h();
        private static final /* synthetic */ h[] e;

        public static h[] values() {
            return (h[])e.clone();
        }

        public static h valueOf(String var0) {
            return Enum.valueOf(h.class, var0);
        }

        private static /* synthetic */ h[] a() {
            return new h[]{CATEGORY, INVENTORY, HOTBAR, SEARCH};
        }

        static {
            e = h.a();
        }
    }

    public static class a {
        private static final b EMPTY_GENERATOR = (var0, var1) -> {};
        private final f row;
        private final int column;
        private IChatBaseComponent displayName = IChatBaseComponent.empty();
        private Supplier<ItemStack> iconGenerator = () -> ItemStack.EMPTY;
        private b displayItemsGenerator = EMPTY_GENERATOR;
        private boolean canScroll = true;
        private boolean showTitle = true;
        private boolean alignedRight = false;
        private h type = h.CATEGORY;
        private MinecraftKey backgroundTexture = DEFAULT_BACKGROUND;

        public a(f var0, int var1) {
            this.row = var0;
            this.column = var1;
        }

        public a title(IChatBaseComponent var0) {
            this.displayName = var0;
            return this;
        }

        public a icon(Supplier<ItemStack> var0) {
            this.iconGenerator = var0;
            return this;
        }

        public a displayItems(b var0) {
            this.displayItemsGenerator = var0;
            return this;
        }

        public a alignedRight() {
            this.alignedRight = true;
            return this;
        }

        public a hideTitle() {
            this.showTitle = false;
            return this;
        }

        public a noScrollBar() {
            this.canScroll = false;
            return this;
        }

        protected a type(h var0) {
            this.type = var0;
            return this;
        }

        public a backgroundTexture(MinecraftKey var0) {
            this.backgroundTexture = var0;
            return this;
        }

        public CreativeModeTab build() {
            if ((this.type == h.HOTBAR || this.type == h.INVENTORY) && this.displayItemsGenerator != EMPTY_GENERATOR) {
                throw new IllegalStateException("Special tabs can't have display items");
            }
            CreativeModeTab var0 = new CreativeModeTab(this.row, this.column, this.type, this.displayName, this.iconGenerator, this.displayItemsGenerator);
            var0.alignedRight = this.alignedRight;
            var0.showTitle = this.showTitle;
            var0.canScroll = this.canScroll;
            var0.backgroundTexture = this.backgroundTexture;
            return var0;
        }
    }

    static class c
    implements e {
        public final Collection<ItemStack> tabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        public final Set<ItemStack> searchTabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        private final CreativeModeTab tab;
        private final FeatureFlagSet featureFlagSet;

        public c(CreativeModeTab var0, FeatureFlagSet var1) {
            this.tab = var0;
            this.featureFlagSet = var1;
        }

        @Override
        public void accept(ItemStack var0, g var1) {
            boolean var2;
            if (var0.getCount() != 1) {
                throw new IllegalArgumentException("Stack size must be exactly 1");
            }
            boolean bl = var2 = this.tabContents.contains(var0) && var1 != g.SEARCH_TAB_ONLY;
            if (var2) {
                throw new IllegalStateException("Accidentally adding the same item stack twice " + var0.getDisplayName().getString() + " to a Creative Mode Tab: " + this.tab.getDisplayName().getString());
            }
            if (var0.getItem().isEnabled(this.featureFlagSet)) {
                switch (var1.ordinal()) {
                    case 0: {
                        this.tabContents.add(var0);
                        this.searchTabContents.add(var0);
                        break;
                    }
                    case 1: {
                        this.tabContents.add(var0);
                        break;
                    }
                    case 2: {
                        this.searchTabContents.add(var0);
                    }
                }
            }
        }
    }

    public static final class d
    extends Record {
        final FeatureFlagSet enabledFeatures;
        private final boolean hasPermissions;
        private final HolderLookup.a holders;

        public d(FeatureFlagSet var0, boolean var1, HolderLookup.a var2) {
            this.enabledFeatures = var0;
            this.hasPermissions = var1;
            this.holders = var2;
        }

        public boolean needsUpdate(FeatureFlagSet var0, boolean var1, HolderLookup.a var2) {
            return !this.enabledFeatures.equals(var0) || this.hasPermissions != var1 || this.holders != var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this, var0);
        }

        public FeatureFlagSet enabledFeatures() {
            return this.enabledFeatures;
        }

        public boolean hasPermissions() {
            return this.hasPermissions;
        }

        public HolderLookup.a holders() {
            return this.holders;
        }
    }

    public static interface e {
        public void accept(ItemStack var1, g var2);

        default public void accept(ItemStack var0) {
            this.accept(var0, g.PARENT_AND_SEARCH_TABS);
        }

        default public void accept(IMaterial var0, g var1) {
            this.accept(new ItemStack(var0), var1);
        }

        default public void accept(IMaterial var0) {
            this.accept(new ItemStack(var0), g.PARENT_AND_SEARCH_TABS);
        }

        default public void acceptAll(Collection<ItemStack> var0, g var12) {
            var0.forEach(var1 -> this.accept((ItemStack)var1, var12));
        }

        default public void acceptAll(Collection<ItemStack> var0) {
            this.acceptAll(var0, g.PARENT_AND_SEARCH_TABS);
        }
    }

    protected static final class g
    extends Enum<g> {
        public static final /* enum */ g PARENT_AND_SEARCH_TABS = new g();
        public static final /* enum */ g PARENT_TAB_ONLY = new g();
        public static final /* enum */ g SEARCH_TAB_ONLY = new g();
        private static final /* synthetic */ g[] d;

        public static g[] values() {
            return (g[])d.clone();
        }

        public static g valueOf(String var0) {
            return Enum.valueOf(g.class, var0);
        }

        private static /* synthetic */ g[] a() {
            return new g[]{PARENT_AND_SEARCH_TABS, PARENT_TAB_ONLY, SEARCH_TAB_ONLY};
        }

        static {
            d = g.a();
        }
    }
}

