/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.jspecify.annotations.Nullable;

public final class FeatureFlagSet {
    private static final FeatureFlagSet EMPTY = new FeatureFlagSet(null, 0L);
    public static final int MAX_CONTAINER_SIZE = 64;
    private final @Nullable FeatureFlagUniverse universe;
    private final long mask;

    private FeatureFlagSet(@Nullable FeatureFlagUniverse var0, long var1) {
        this.universe = var0;
        this.mask = var1;
    }

    static FeatureFlagSet create(FeatureFlagUniverse var0, Collection<FeatureFlag> var1) {
        if (var1.isEmpty()) {
            return EMPTY;
        }
        long var2 = FeatureFlagSet.computeMask(var0, 0L, var1);
        return new FeatureFlagSet(var0, var2);
    }

    public static FeatureFlagSet of() {
        return EMPTY;
    }

    public static FeatureFlagSet of(FeatureFlag var0) {
        return new FeatureFlagSet(var0.universe, var0.mask);
    }

    public static FeatureFlagSet of(FeatureFlag var0, FeatureFlag ... var1) {
        long var2 = var1.length == 0 ? var0.mask : FeatureFlagSet.computeMask(var0.universe, var0.mask, Arrays.asList(var1));
        return new FeatureFlagSet(var0.universe, var2);
    }

    private static long computeMask(FeatureFlagUniverse var0, long var1, Iterable<FeatureFlag> var3) {
        for (FeatureFlag var5 : var3) {
            if (var0 != var5.universe) {
                throw new IllegalStateException("Mismatched feature universe, expected '" + String.valueOf(var0) + "', but got '" + String.valueOf(var5.universe) + "'");
            }
            var1 |= var5.mask;
        }
        return var1;
    }

    public boolean contains(FeatureFlag var0) {
        if (this.universe != var0.universe) {
            return false;
        }
        return (this.mask & var0.mask) != 0L;
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean isSubsetOf(FeatureFlagSet var0) {
        if (this.universe == null) {
            return true;
        }
        if (this.universe != var0.universe) {
            return false;
        }
        return (this.mask & (var0.mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public boolean intersects(FeatureFlagSet var0) {
        if (this.universe == null || var0.universe == null || this.universe != var0.universe) {
            return false;
        }
        return (this.mask & var0.mask) != 0L;
    }

    public FeatureFlagSet join(FeatureFlagSet var0) {
        if (this.universe == null) {
            return var0;
        }
        if (var0.universe == null) {
            return this;
        }
        if (this.universe != var0.universe) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.universe) + "' != '" + String.valueOf(var0.universe) + "'");
        }
        return new FeatureFlagSet(this.universe, this.mask | var0.mask);
    }

    public FeatureFlagSet subtract(FeatureFlagSet var0) {
        if (this.universe == null || var0.universe == null) {
            return this;
        }
        if (this.universe != var0.universe) {
            throw new IllegalArgumentException("Mismatched set elements: '" + String.valueOf(this.universe) + "' != '" + String.valueOf(var0.universe) + "'");
        }
        long var1 = this.mask & (var0.mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (var1 == 0L) {
            return EMPTY;
        }
        return new FeatureFlagSet(this.universe, var1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof FeatureFlagSet)) return false;
        FeatureFlagSet var1 = (FeatureFlagSet)var0;
        if (this.universe != var1.universe) return false;
        if (this.mask != var1.mask) return false;
        return true;
    }

    public int hashCode() {
        return (int)HashCommon.mix((long)this.mask);
    }
}

