/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRaid;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.illager.EntityIllagerAbstract;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public abstract class EntityRaider
extends EntityMonsterPatrolling {
    protected static final DataWatcherObject<Boolean> IS_CELEBRATING = DataWatcher.defineId(EntityRaider.class, DataWatcherRegistry.BOOLEAN);
    static final Predicate<EntityItem> ALLOWED_ITEMS = var0 -> !var0.hasPickUpDelay() && var0.isAlive() && ItemStack.matches(var0.getItem(), Raid.getOminousBannerInstance(var0.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
    private static final int DEFAULT_WAVE = 0;
    private static final boolean DEFAULT_CAN_JOIN_RAID = false;
    protected @Nullable Raid raid;
    private int wave = 0;
    private boolean canJoinRaid = false;
    private int ticksOutsideRaid;

    protected EntityRaider(EntityTypes<? extends EntityRaider> var0, World var1) {
        super((EntityTypes<? extends EntityMonsterPatrolling>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new b(this));
        this.goalSelector.addGoal(3, new PathfinderGoalRaid<EntityRaider>(this));
        this.goalSelector.addGoal(4, new d(this, 1.05f, 1));
        this.goalSelector.addGoal(5, new c(this));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(IS_CELEBRATING, false);
    }

    public abstract void applyRaidBuffs(WorldServer var1, int var2, boolean var3);

    public boolean canJoinRaid() {
        return this.canJoinRaid;
    }

    public void setCanJoinRaid(boolean var0) {
        this.canJoinRaid = var0;
    }

    @Override
    public void aiStep() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            if (this.isAlive()) {
                Raid var1 = this.getCurrentRaid();
                if (this.canJoinRaid()) {
                    if (var1 == null) {
                        Raid var2;
                        if (this.level().getGameTime() % 20L == 0L && (var2 = var0.getRaidAt(this.blockPosition())) != null && PersistentRaid.canJoinRaid(this)) {
                            var2.joinRaid(var0, var2.getGroupsSpawned(), this, null, true);
                        }
                    } else {
                        EntityLiving var2 = this.getTarget();
                        if (var2 != null && (var2.getType() == EntityTypes.PLAYER || var2.getType() == EntityTypes.IRON_GOLEM)) {
                            this.noActionTime = 0;
                        }
                    }
                }
            }
        }
        super.aiStep();
    }

    @Override
    protected void updateNoActionTime() {
        this.noActionTime += 2;
    }

    @Override
    public void die(DamageSource var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            Entity var2 = var0.getEntity();
            Raid var3 = this.getCurrentRaid();
            if (var3 != null) {
                if (this.isPatrolLeader()) {
                    var3.removeLeader(this.getWave());
                }
                if (var2 != null && var2.getType() == EntityTypes.PLAYER) {
                    var3.addHeroOfTheVillage(var2);
                }
                var3.removeFromRaid(var1, this, false);
            }
        }
        super.die(var0);
    }

    @Override
    public boolean canJoinPatrol() {
        return !this.hasActiveRaid();
    }

    public void setCurrentRaid(@Nullable Raid var0) {
        this.raid = var0;
    }

    public @Nullable Raid getCurrentRaid() {
        return this.raid;
    }

    public boolean isCaptain() {
        ItemStack var0 = this.getItemBySlot(EnumItemSlot.HEAD);
        boolean var1 = !var0.isEmpty() && ItemStack.matches(var0, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        boolean var2 = this.isPatrolLeader();
        return var1 && var2;
    }

    public boolean hasRaid() {
        World world = this.level();
        if (!(world instanceof WorldServer)) {
            return false;
        }
        WorldServer var0 = (WorldServer)world;
        return this.getCurrentRaid() != null || var0.getRaidAt(this.blockPosition()) != null;
    }

    public boolean hasActiveRaid() {
        return this.getCurrentRaid() != null && this.getCurrentRaid().isActive();
    }

    public void setWave(int var0) {
        this.wave = var0;
    }

    public int getWave() {
        return this.wave;
    }

    public boolean isCelebrating() {
        return this.entityData.get(IS_CELEBRATING);
    }

    public void setCelebrating(boolean var0) {
        this.entityData.set(IS_CELEBRATING, var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        World world;
        super.addAdditionalSaveData(var0);
        var0.putInt("Wave", this.wave);
        var0.putBoolean("CanJoinRaid", this.canJoinRaid);
        if (this.raid != null && (world = this.level()) instanceof WorldServer) {
            WorldServer var12 = (WorldServer)world;
            var12.getRaids().getId(this.raid).ifPresent(var1 -> var0.putInt("RaidId", var1));
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.wave = var0.getIntOr("Wave", 0);
        this.canJoinRaid = var0.getBooleanOr("CanJoinRaid", false);
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var12 = (WorldServer)world;
            var0.getInt("RaidId").ifPresent(var1 -> {
                this.raid = var12.getRaids().get((int)var1);
                if (this.raid != null) {
                    this.raid.addWaveMob(var12, this.wave, this, false);
                    if (this.isPatrolLeader()) {
                        this.raid.setLeader(this.wave, this);
                    }
                }
            });
        }
    }

    @Override
    protected void pickUpItem(WorldServer var0, EntityItem var1) {
        boolean var3;
        ItemStack var2 = var1.getItem();
        boolean bl = var3 = this.hasActiveRaid() && this.getCurrentRaid().getLeader(this.getWave()) != null;
        if (this.hasActiveRaid() && !var3 && ItemStack.matches(var2, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
            EnumItemSlot var4 = EnumItemSlot.HEAD;
            ItemStack var5 = this.getItemBySlot(var4);
            double var6 = this.getDropChances().byEquipment(var4);
            if (!var5.isEmpty() && (double)Math.max(this.random.nextFloat() - 0.1f, 0.0f) < var6) {
                this.spawnAtLocation(var0, var5);
            }
            this.onItemPickup(var1);
            this.setItemSlot(var4, var2);
            this.take(var1, var2.getCount());
            var1.discard();
            this.getCurrentRaid().setLeader(this.getWave(), this);
            this.setPatrolLeader(true);
        } else {
            super.pickUpItem(var0, var1);
        }
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        if (this.getCurrentRaid() == null) {
            return super.removeWhenFarAway(var0);
        }
        return false;
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.getCurrentRaid() != null;
    }

    public int getTicksOutsideRaid() {
        return this.ticksOutsideRaid;
    }

    public void setTicksOutsideRaid(int var0) {
        this.ticksOutsideRaid = var0;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.hasActiveRaid()) {
            this.getCurrentRaid().updateBossbar();
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        this.setCanJoinRaid(this.getType() != EntityTypes.WITCH || var2 != EntitySpawnReason.NATURAL);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public abstract SoundEffect getCelebrateSound();

    public class b<T extends EntityRaider>
    extends PathfinderGoal {
        private final T mob;
        private Int2LongOpenHashMap unreachableBannerCache = new Int2LongOpenHashMap();
        private @Nullable PathEntity pathToBanner;
        private @Nullable EntityItem pursuedBannerItemEntity;

        public b(EntityRaider var1) {
            this.mob = var1;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (this.cannotPickUpBanner()) {
                return false;
            }
            Int2LongOpenHashMap var0 = new Int2LongOpenHashMap();
            double var1 = EntityRaider.this.getAttributeValue(GenericAttributes.FOLLOW_RANGE);
            List<EntityItem> var3 = ((Entity)this.mob).level().getEntitiesOfClass(EntityItem.class, ((Entity)this.mob).getBoundingBox().inflate(var1, 8.0, var1), ALLOWED_ITEMS);
            for (EntityItem var5 : var3) {
                long var6 = this.unreachableBannerCache.getOrDefault(var5.getId(), Long.MIN_VALUE);
                if (EntityRaider.this.level().getGameTime() < var6) {
                    var0.put(var5.getId(), var6);
                    continue;
                }
                PathEntity var8 = ((EntityInsentient)this.mob).getNavigation().createPath(var5, 1);
                if (var8 != null && var8.canReach()) {
                    this.pathToBanner = var8;
                    this.pursuedBannerItemEntity = var5;
                    return true;
                }
                var0.put(var5.getId(), EntityRaider.this.level().getGameTime() + 600L);
            }
            this.unreachableBannerCache = var0;
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.pursuedBannerItemEntity == null || this.pathToBanner == null) {
                return false;
            }
            if (this.pursuedBannerItemEntity.isRemoved()) {
                return false;
            }
            if (this.pathToBanner.isDone()) {
                return false;
            }
            return !this.cannotPickUpBanner();
        }

        private boolean cannotPickUpBanner() {
            if (!((EntityRaider)this.mob).hasActiveRaid()) {
                return true;
            }
            if (((EntityRaider)this.mob).getCurrentRaid().isOver()) {
                return true;
            }
            if (!((EntityMonsterPatrolling)this.mob).canBeLeader()) {
                return true;
            }
            if (ItemStack.matches(((EntityLiving)this.mob).getItemBySlot(EnumItemSlot.HEAD), Raid.getOminousBannerInstance(((Entity)this.mob).registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)))) {
                return true;
            }
            EntityRaider var0 = EntityRaider.this.raid.getLeader(((EntityRaider)this.mob).getWave());
            return var0 != null && var0.isAlive();
        }

        @Override
        public void start() {
            ((EntityInsentient)this.mob).getNavigation().moveTo(this.pathToBanner, (double)1.15f);
        }

        @Override
        public void stop() {
            this.pathToBanner = null;
            this.pursuedBannerItemEntity = null;
        }

        @Override
        public void tick() {
            if (this.pursuedBannerItemEntity != null && this.pursuedBannerItemEntity.closerThan((Entity)this.mob, 1.414)) {
                ((EntityRaider)this.mob).pickUpItem(b.getServerLevel(EntityRaider.this.level()), this.pursuedBannerItemEntity);
            }
        }
    }

    static class d
    extends PathfinderGoal {
        private final EntityRaider raider;
        private final double speedModifier;
        private BlockPosition poiPos;
        private final List<BlockPosition> visited = Lists.newArrayList();
        private final int distanceToPoi;
        private boolean stuck;

        public d(EntityRaider var0, double var1, int var3) {
            this.raider = var0;
            this.speedModifier = var1;
            this.distanceToPoi = var3;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            this.updateVisited();
            return this.isValidRaid() && this.hasSuitablePoi() && this.raider.getTarget() == null;
        }

        private boolean isValidRaid() {
            return this.raider.hasActiveRaid() && !this.raider.getCurrentRaid().isOver();
        }

        private boolean hasSuitablePoi() {
            WorldServer var02 = (WorldServer)this.raider.level();
            BlockPosition var1 = this.raider.blockPosition();
            Optional<BlockPosition> var2 = var02.getPoiManager().getRandom(var0 -> var0.is(PoiTypes.HOME), this::hasNotVisited, VillagePlace.Occupancy.ANY, var1, 48, this.raider.random);
            if (var2.isEmpty()) {
                return false;
            }
            this.poiPos = var2.get().immutable();
            return true;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.raider.getNavigation().isDone()) {
                return false;
            }
            return this.raider.getTarget() == null && !this.poiPos.closerToCenterThan(this.raider.position(), this.raider.getBbWidth() + (float)this.distanceToPoi) && !this.stuck;
        }

        @Override
        public void stop() {
            if (this.poiPos.closerToCenterThan(this.raider.position(), this.distanceToPoi)) {
                this.visited.add(this.poiPos);
            }
        }

        @Override
        public void start() {
            super.start();
            this.raider.setNoActionTime(0);
            this.raider.getNavigation().moveTo(this.poiPos.getX(), this.poiPos.getY(), this.poiPos.getZ(), this.speedModifier);
            this.stuck = false;
        }

        @Override
        public void tick() {
            if (this.raider.getNavigation().isDone()) {
                Vec3D var0 = Vec3D.atBottomCenterOf(this.poiPos);
                Vec3D var1 = DefaultRandomPos.getPosTowards(this.raider, 16, 7, var0, 0.3141592741012573);
                if (var1 == null) {
                    var1 = DefaultRandomPos.getPosTowards(this.raider, 8, 7, var0, 1.5707963705062866);
                }
                if (var1 == null) {
                    this.stuck = true;
                    return;
                }
                this.raider.getNavigation().moveTo(var1.x, var1.y, var1.z, this.speedModifier);
            }
        }

        private boolean hasNotVisited(BlockPosition var0) {
            for (BlockPosition var2 : this.visited) {
                if (!Objects.equals(var0, var2)) continue;
                return false;
            }
            return true;
        }

        private void updateVisited() {
            if (this.visited.size() > 2) {
                this.visited.remove(0);
            }
        }
    }

    public class c
    extends PathfinderGoal {
        private final EntityRaider mob;

        c(EntityRaider var1) {
            this.mob = var1;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            Raid var0 = this.mob.getCurrentRaid();
            return this.mob.isAlive() && this.mob.getTarget() == null && var0 != null && var0.isLoss();
        }

        @Override
        public void start() {
            this.mob.setCelebrating(true);
            super.start();
        }

        @Override
        public void stop() {
            this.mob.setCelebrating(false);
            super.stop();
        }

        @Override
        public void tick() {
            if (!this.mob.isSilent() && this.mob.random.nextInt(this.adjustedTickDelay(100)) == 0) {
                EntityRaider.this.makeSound(EntityRaider.this.getCelebrateSound());
            }
            if (!this.mob.isPassenger() && this.mob.random.nextInt(this.adjustedTickDelay(50)) == 0) {
                this.mob.getJumpControl().jump();
            }
            super.tick();
        }
    }

    protected static class a
    extends PathfinderGoal {
        private final EntityRaider mob;
        private final float hostileRadiusSqr;
        public final PathfinderTargetCondition shoutTargeting = PathfinderTargetCondition.forNonCombat().range(8.0).ignoreLineOfSight().ignoreInvisibilityTesting();

        public a(EntityIllagerAbstract var0, float var1) {
            this.mob = var0;
            this.hostileRadiusSqr = var1 * var1;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = this.mob.getLastHurtByMob();
            return this.mob.getCurrentRaid() == null && this.mob.isPatrolling() && this.mob.getTarget() != null && !this.mob.isAggressive() && (var0 == null || var0.getType() != EntityTypes.PLAYER);
        }

        @Override
        public void start() {
            super.start();
            this.mob.getNavigation().stop();
            List<EntityRaider> var0 = a.getServerLevel(this.mob).getNearbyEntities(EntityRaider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
            for (EntityRaider var2 : var0) {
                var2.setTarget(this.mob.getTarget());
            }
        }

        @Override
        public void stop() {
            super.stop();
            EntityLiving var0 = this.mob.getTarget();
            if (var0 != null) {
                List<EntityRaider> var1 = a.getServerLevel(this.mob).getNearbyEntities(EntityRaider.class, this.shoutTargeting, this.mob, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0));
                for (EntityRaider var3 : var1) {
                    var3.setTarget(var0);
                    var3.setAggressive(true);
                }
                this.mob.setAggressive(true);
            }
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            EntityLiving var0 = this.mob.getTarget();
            if (var0 == null) {
                return;
            }
            if (this.mob.distanceToSqr(var0) > (double)this.hostileRadiusSqr) {
                this.mob.getLookControl().setLookAt(var0, 30.0f, 30.0f);
                if (this.mob.random.nextInt(50) == 0) {
                    this.mob.playAmbientSound();
                }
            } else {
                this.mob.setAggressive(true);
            }
            super.tick();
        }
    }
}

