/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.entity.projectile.throwableitemprojectile.EntityPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;

public class ThrownSplashPotion
extends EntityPotion {
    public ThrownSplashPotion(EntityTypes<? extends ThrownSplashPotion> var0, World var1) {
        super((EntityTypes<? extends EntityPotion>)var0, var1);
    }

    public ThrownSplashPotion(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.SPLASH_POTION, var0, var1, var2);
    }

    public ThrownSplashPotion(World var0, double var1, double var3, double var5, ItemStack var7) {
        super(EntityTypes.SPLASH_POTION, var0, var1, var3, var5, var7);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    public void onHitAsPotion(WorldServer var0, ItemStack var1, MovingObjectPosition var2) {
        PotionContents var32 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        float var4 = var1.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffect> var5 = var32.getAllEffects();
        AxisAlignedBB var6 = this.getBoundingBox().move(var2.getLocation().subtract(this.position()));
        AxisAlignedBB var7 = var6.inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var8 = this.level().getEntitiesOfClass(EntityLiving.class, var7);
        float var9 = ProjectileHelper.computeMargin(this);
        if (!var8.isEmpty()) {
            Entity var10 = this.getEffectSource();
            for (EntityLiving var12 : var8) {
                double var13;
                if (!var12.isAffectedByPotions() || !((var13 = var6.distanceToSqr(var12.getBoundingBox().inflate(var9))) < 16.0)) continue;
                double var15 = 1.0 - Math.sqrt(var13) / 4.0;
                for (MobEffect var18 : var5) {
                    Holder<MobEffectList> var19 = var18.getEffect();
                    if (var19.value().isInstantenous()) {
                        var19.value().applyInstantenousEffect(var0, this, this.getOwner(), var12, var18.getAmplifier(), var15);
                        continue;
                    }
                    int var20 = var18.mapDuration(var3 -> (int)(var15 * (double)var3 * (double)var4 + 0.5));
                    MobEffect var21 = new MobEffect(var19, var20, var18.getAmplifier(), var18.isAmbient(), var18.isVisible());
                    if (var21.endsWithin(20)) continue;
                    var12.addEffect(var21, var10);
                }
            }
        }
    }
}

