/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.wanderingtrader;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.equine.EntityLlamaTrader;
import net.minecraft.world.entity.npc.wanderingtrader.EntityVillagerTrader;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.storage.IWorldDataServer;
import org.jspecify.annotations.Nullable;

public class MobSpawnerTrader
implements MobSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private final RandomSource random = RandomSource.create();
    private final IWorldDataServer serverLevelData;
    private int tickDelay;
    private int spawnDelay;
    private int spawnChance;

    public MobSpawnerTrader(IWorldDataServer var0) {
        this.serverLevelData = var0;
        this.tickDelay = 1200;
        this.spawnDelay = var0.getWanderingTraderSpawnDelay();
        this.spawnChance = var0.getWanderingTraderSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            var0.setWanderingTraderSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            var0.setWanderingTraderSpawnChance(this.spawnChance);
        }
    }

    @Override
    public void tick(WorldServer var0, boolean var1) {
        if (!var0.getGameRules().get(GameRules.SPAWN_WANDERING_TRADERS).booleanValue()) {
            return;
        }
        if (--this.tickDelay > 0) {
            return;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        this.serverLevelData.setWanderingTraderSpawnDelay(this.spawnDelay);
        if (this.spawnDelay > 0) {
            return;
        }
        this.spawnDelay = 24000;
        int var2 = this.spawnChance;
        this.spawnChance = MathHelper.clamp(this.spawnChance + 25, 25, 75);
        this.serverLevelData.setWanderingTraderSpawnChance(this.spawnChance);
        if (this.random.nextInt(100) > var2) {
            return;
        }
        if (this.spawn(var0)) {
            this.spawnChance = 25;
        }
    }

    private boolean spawn(WorldServer var02) {
        EntityPlayer var1 = var02.getRandomPlayer();
        if (var1 == null) {
            return true;
        }
        if (this.random.nextInt(10) != 0) {
            return false;
        }
        BlockPosition var2 = var1.blockPosition();
        int var3 = 48;
        VillagePlace var4 = var02.getPoiManager();
        Optional<BlockPosition> var5 = var4.find(var0 -> var0.is(PoiTypes.MEETING), var0 -> true, var2, 48, VillagePlace.Occupancy.ANY);
        BlockPosition var6 = var5.orElse(var2);
        BlockPosition var7 = this.findSpawnPositionNear(var02, var6, 48);
        if (var7 != null && this.hasEnoughSpace(var02, var7)) {
            if (var02.getBiome(var7).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                return false;
            }
            EntityVillagerTrader var8 = EntityTypes.WANDERING_TRADER.spawn(var02, var7, EntitySpawnReason.EVENT);
            if (var8 != null) {
                for (int var9 = 0; var9 < 2; ++var9) {
                    this.tryToSpawnLlamaFor(var02, var8, 4);
                }
                this.serverLevelData.setWanderingTraderId(var8.getUUID());
                var8.setDespawnDelay(48000);
                var8.setWanderTarget(var6);
                var8.setHomeTo(var6, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnLlamaFor(WorldServer var0, EntityVillagerTrader var1, int var2) {
        BlockPosition var3 = this.findSpawnPositionNear(var0, var1.blockPosition(), var2);
        if (var3 == null) {
            return;
        }
        EntityLlamaTrader var4 = EntityTypes.TRADER_LLAMA.spawn(var0, var3, EntitySpawnReason.EVENT);
        if (var4 == null) {
            return;
        }
        var4.setLeashedTo(var1, true);
    }

    private @Nullable BlockPosition findSpawnPositionNear(IWorldReader var0, BlockPosition var1, int var2) {
        BlockPosition var3 = null;
        SpawnPlacementType var4 = EntityPositionTypes.getPlacementType(EntityTypes.WANDERING_TRADER);
        for (int var5 = 0; var5 < 10; ++var5) {
            int var7;
            int var8;
            int var6 = var1.getX() + this.random.nextInt(var2 * 2) - var2;
            BlockPosition var9 = new BlockPosition(var6, var8 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var6, var7 = var1.getZ() + this.random.nextInt(var2 * 2) - var2), var7);
            if (!var4.isSpawnPositionOk(var0, var9, EntityTypes.WANDERING_TRADER)) continue;
            var3 = var9;
            break;
        }
        return var3;
    }

    private boolean hasEnoughSpace(IBlockAccess var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.betweenClosed(var1, var1.offset(1, 2, 1))) {
            if (var0.getBlockState(var3).getCollisionShape(var0, var3).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

