/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc.villager;

import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jspecify.annotations.Nullable;

public record VillagerProfession(IChatBaseComponent name, Predicate<Holder<VillagePlaceType>> heldJobSite, Predicate<Holder<VillagePlaceType>> acquirableJobSite, ImmutableSet<Item> requestedItems, ImmutableSet<Block> secondaryPoi, @Nullable SoundEffect workSound) {
    public static final Predicate<Holder<VillagePlaceType>> ALL_ACQUIRABLE_JOBS = var0 -> var0.is(PoiTypeTags.ACQUIRABLE_JOB_SITE);
    public static final ResourceKey<VillagerProfession> NONE = VillagerProfession.createKey("none");
    public static final ResourceKey<VillagerProfession> ARMORER = VillagerProfession.createKey("armorer");
    public static final ResourceKey<VillagerProfession> BUTCHER = VillagerProfession.createKey("butcher");
    public static final ResourceKey<VillagerProfession> CARTOGRAPHER = VillagerProfession.createKey("cartographer");
    public static final ResourceKey<VillagerProfession> CLERIC = VillagerProfession.createKey("cleric");
    public static final ResourceKey<VillagerProfession> FARMER = VillagerProfession.createKey("farmer");
    public static final ResourceKey<VillagerProfession> FISHERMAN = VillagerProfession.createKey("fisherman");
    public static final ResourceKey<VillagerProfession> FLETCHER = VillagerProfession.createKey("fletcher");
    public static final ResourceKey<VillagerProfession> LEATHERWORKER = VillagerProfession.createKey("leatherworker");
    public static final ResourceKey<VillagerProfession> LIBRARIAN = VillagerProfession.createKey("librarian");
    public static final ResourceKey<VillagerProfession> MASON = VillagerProfession.createKey("mason");
    public static final ResourceKey<VillagerProfession> NITWIT = VillagerProfession.createKey("nitwit");
    public static final ResourceKey<VillagerProfession> SHEPHERD = VillagerProfession.createKey("shepherd");
    public static final ResourceKey<VillagerProfession> TOOLSMITH = VillagerProfession.createKey("toolsmith");
    public static final ResourceKey<VillagerProfession> WEAPONSMITH = VillagerProfession.createKey("weaponsmith");

    private static ResourceKey<VillagerProfession> createKey(String var0) {
        return ResourceKey.create(Registries.VILLAGER_PROFESSION, MinecraftKey.withDefaultNamespace(var0));
    }

    private static VillagerProfession register(IRegistry<VillagerProfession> var0, ResourceKey<VillagerProfession> var12, ResourceKey<VillagePlaceType> var2, @Nullable SoundEffect var3) {
        return VillagerProfession.register(var0, var12, var1 -> var1.is(var2), var1 -> var1.is(var2), var3);
    }

    private static VillagerProfession register(IRegistry<VillagerProfession> var0, ResourceKey<VillagerProfession> var1, Predicate<Holder<VillagePlaceType>> var2, Predicate<Holder<VillagePlaceType>> var3, @Nullable SoundEffect var4) {
        return VillagerProfession.register(var0, var1, var2, var3, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), var4);
    }

    private static VillagerProfession register(IRegistry<VillagerProfession> var0, ResourceKey<VillagerProfession> var12, ResourceKey<VillagePlaceType> var2, ImmutableSet<Item> var3, ImmutableSet<Block> var4, @Nullable SoundEffect var5) {
        return VillagerProfession.register(var0, var12, var1 -> var1.is(var2), var1 -> var1.is(var2), var3, var4, var5);
    }

    private static VillagerProfession register(IRegistry<VillagerProfession> var0, ResourceKey<VillagerProfession> var1, Predicate<Holder<VillagePlaceType>> var2, Predicate<Holder<VillagePlaceType>> var3, ImmutableSet<Item> var4, ImmutableSet<Block> var5, @Nullable SoundEffect var6) {
        return IRegistry.register(var0, var1, new VillagerProfession(IChatBaseComponent.translatable("entity." + var1.identifier().getNamespace() + ".villager." + var1.identifier().getPath()), var2, var3, var4, var5, var6));
    }

    public static VillagerProfession bootstrap(IRegistry<VillagerProfession> var0) {
        VillagerProfession.register(var0, NONE, VillagePlaceType.NONE, ALL_ACQUIRABLE_JOBS, null);
        VillagerProfession.register(var0, ARMORER, PoiTypes.ARMORER, SoundEffects.VILLAGER_WORK_ARMORER);
        VillagerProfession.register(var0, BUTCHER, PoiTypes.BUTCHER, SoundEffects.VILLAGER_WORK_BUTCHER);
        VillagerProfession.register(var0, CARTOGRAPHER, PoiTypes.CARTOGRAPHER, SoundEffects.VILLAGER_WORK_CARTOGRAPHER);
        VillagerProfession.register(var0, CLERIC, PoiTypes.CLERIC, SoundEffects.VILLAGER_WORK_CLERIC);
        VillagerProfession.register(var0, FARMER, PoiTypes.FARMER, (ImmutableSet<Item>)ImmutableSet.of((Object)Items.WHEAT, (Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS, (Object)Items.BONE_MEAL), (ImmutableSet<Block>)ImmutableSet.of((Object)Blocks.FARMLAND), SoundEffects.VILLAGER_WORK_FARMER);
        VillagerProfession.register(var0, FISHERMAN, PoiTypes.FISHERMAN, SoundEffects.VILLAGER_WORK_FISHERMAN);
        VillagerProfession.register(var0, FLETCHER, PoiTypes.FLETCHER, SoundEffects.VILLAGER_WORK_FLETCHER);
        VillagerProfession.register(var0, LEATHERWORKER, PoiTypes.LEATHERWORKER, SoundEffects.VILLAGER_WORK_LEATHERWORKER);
        VillagerProfession.register(var0, LIBRARIAN, PoiTypes.LIBRARIAN, SoundEffects.VILLAGER_WORK_LIBRARIAN);
        VillagerProfession.register(var0, MASON, PoiTypes.MASON, SoundEffects.VILLAGER_WORK_MASON);
        VillagerProfession.register(var0, NITWIT, VillagePlaceType.NONE, VillagePlaceType.NONE, null);
        VillagerProfession.register(var0, SHEPHERD, PoiTypes.SHEPHERD, SoundEffects.VILLAGER_WORK_SHEPHERD);
        VillagerProfession.register(var0, TOOLSMITH, PoiTypes.TOOLSMITH, SoundEffects.VILLAGER_WORK_TOOLSMITH);
        return VillagerProfession.register(var0, WEAPONSMITH, PoiTypes.WEAPONSMITH, SoundEffects.VILLAGER_WORK_WEAPONSMITH);
    }
}

