/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import org.jspecify.annotations.Nullable;

public class EntityZombieHusk
extends EntityZombie {
    public EntityZombieHusk(EntityTypes<? extends EntityZombieHusk> var0, World var1) {
        super((EntityTypes<? extends EntityZombie>)var0, var1);
    }

    @Override
    protected boolean isSunSensitive() {
        return false;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.HUSK_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HUSK_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HUSK_DEATH;
    }

    @Override
    protected SoundEffect getStepSound() {
        return SoundEffects.HUSK_STEP;
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        boolean var2 = super.doHurtTarget(var0, var1);
        if (var2 && this.getMainHandItem().isEmpty() && var1 instanceof EntityLiving) {
            float var3 = var0.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((EntityLiving)var1).addEffect(new MobEffect(MobEffects.HUNGER, 140 * (int)var3), this);
        }
        return var2;
    }

    @Override
    protected boolean convertsInWater() {
        return true;
    }

    @Override
    protected void doUnderWaterConversion(WorldServer var0) {
        this.convertToZombieType(var0, EntityTypes.ZOMBIE);
        if (!this.isSilent()) {
            var0.levelEvent(null, 1041, this.blockPosition(), 0);
        }
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        var3 = super.finalizeSpawn(var0, var1, var2, var3);
        float var5 = var1.getSpecialMultiplier();
        if (var2 != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(var4.nextFloat() < 0.55f * var5);
        }
        if (var3 != null) {
            var3 = new a((EntityZombie.GroupDataZombie)var3);
            boolean bl = ((a)var3).triedToSpawnCamelHusk = var2 != EntitySpawnReason.NATURAL;
        }
        if (var3 instanceof a) {
            BlockPosition var7;
            a var6 = (a)var3;
            if (!var6.triedToSpawnCamelHusk && var0.noCollision(EntityTypes.CAMEL_HUSK.getSpawnAABB((double)(var7 = this.blockPosition()).getX() + 0.5, var7.getY(), (double)var7.getZ() + 0.5))) {
                var6.triedToSpawnCamelHusk = true;
                if (var4.nextFloat() < 0.1f) {
                    this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
                    CamelHusk var8 = EntityTypes.CAMEL_HUSK.create(this.level(), EntitySpawnReason.NATURAL);
                    if (var8 != null) {
                        var8.setPos(this.getX(), this.getY(), this.getZ());
                        var8.finalizeSpawn(var0, var1, var2, null);
                        this.startRiding(var8, true, true);
                        var0.addFreshEntity(var8);
                        Parched var9 = EntityTypes.PARCHED.create(this.level(), EntitySpawnReason.NATURAL);
                        if (var9 != null) {
                            var9.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                            var9.finalizeSpawn(var0, var1, var2, null);
                            var9.startRiding(var8, false, false);
                            var0.addFreshEntityWithPassengers(var9);
                        }
                    }
                }
            }
        }
        return var3;
    }

    public static class a
    extends EntityZombie.GroupDataZombie {
        public boolean triedToSpawnCamelHusk = false;

        public a(EntityZombie.GroupDataZombie var0) {
            super(var0.isBaby, var0.canSpawnJockey);
        }
    }
}

