/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.player.EntityHuman;
import org.jspecify.annotations.Nullable;

public class AngerManagement {
    @VisibleForTesting
    protected static final int CONVERSION_DELAY = 2;
    @VisibleForTesting
    protected static final int MAX_ANGER = 150;
    private static final int DEFAULT_ANGER_DECREASE = 1;
    private int conversionDelay = MathHelper.randomBetweenInclusive(RandomSource.create(), 0, 2);
    int highestAnger;
    private static final Codec<Pair<UUID, Integer>> SUSPECT_ANGER_PAIR = RecordCodecBuilder.create(var0 -> var0.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(Pair::getFirst), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("anger").forGetter(Pair::getSecond)).apply((Applicative)var0, Pair::of));
    private final Predicate<Entity> filter;
    @VisibleForTesting
    protected final ArrayList<Entity> suspects;
    private final a suspectSorter;
    @VisibleForTesting
    protected final Object2IntMap<Entity> angerBySuspect;
    @VisibleForTesting
    protected final Object2IntMap<UUID> angerByUuid;

    public static Codec<AngerManagement> codec(Predicate<Entity> var0) {
        return RecordCodecBuilder.create(var12 -> var12.group((App)SUSPECT_ANGER_PAIR.listOf().fieldOf("suspects").orElse(Collections.emptyList()).forGetter(AngerManagement::createUuidAngerPairs)).apply((Applicative)var12, var1 -> new AngerManagement(var0, (List<Pair<UUID, Integer>>)var1)));
    }

    public AngerManagement(Predicate<Entity> var02, List<Pair<UUID, Integer>> var1) {
        this.filter = var02;
        this.suspects = new ArrayList();
        this.suspectSorter = new a(this);
        this.angerBySuspect = new Object2IntOpenHashMap();
        this.angerByUuid = new Object2IntOpenHashMap(var1.size());
        var1.forEach(var0 -> this.angerByUuid.put((Object)((UUID)var0.getFirst()), (Integer)var0.getSecond()));
    }

    private List<Pair<UUID, Integer>> createUuidAngerPairs() {
        return Streams.concat((Stream[])new Stream[]{this.suspects.stream().map(var0 -> Pair.of((Object)var0.getUUID(), (Object)this.angerBySuspect.getInt(var0))), this.angerByUuid.object2IntEntrySet().stream().map(var0 -> Pair.of((Object)((UUID)var0.getKey()), (Object)var0.getIntValue()))}).collect(Collectors.toList());
    }

    public void tick(WorldServer var0, Predicate<Entity> var1) {
        Object2IntMap.Entry var3;
        --this.conversionDelay;
        if (this.conversionDelay <= 0) {
            this.convertFromUuids(var0);
            this.conversionDelay = 2;
        }
        ObjectIterator var2 = this.angerByUuid.object2IntEntrySet().iterator();
        while (var2.hasNext()) {
            var3 = (Object2IntMap.Entry)var2.next();
            int var4 = var3.getIntValue();
            if (var4 <= 1) {
                var2.remove();
                continue;
            }
            var3.setValue(var4 - 1);
        }
        var3 = this.angerBySuspect.object2IntEntrySet().iterator();
        while (var3.hasNext()) {
            Object2IntMap.Entry var4 = (Object2IntMap.Entry)var3.next();
            int var5 = var4.getIntValue();
            Entity var6 = (Entity)var4.getKey();
            Entity.RemovalReason var7 = var6.getRemovalReason();
            if (var5 <= 1 || !var1.test(var6) || var7 != null) {
                this.suspects.remove(var6);
                var3.remove();
                if (var5 <= 1 || var7 == null) continue;
                switch (var7) {
                    case CHANGED_DIMENSION: 
                    case UNLOADED_TO_CHUNK: 
                    case UNLOADED_WITH_PLAYER: {
                        this.angerByUuid.put((Object)var6.getUUID(), var5 - 1);
                    }
                }
                continue;
            }
            var4.setValue(var5 - 1);
        }
        this.sortAndUpdateHighestAnger();
    }

    private void sortAndUpdateHighestAnger() {
        this.highestAnger = 0;
        this.suspects.sort(this.suspectSorter);
        if (this.suspects.size() == 1) {
            this.highestAnger = this.angerBySuspect.getInt((Object)this.suspects.get(0));
        }
    }

    private void convertFromUuids(WorldServer var0) {
        ObjectIterator var1 = this.angerByUuid.object2IntEntrySet().iterator();
        while (var1.hasNext()) {
            Object2IntMap.Entry var2 = (Object2IntMap.Entry)var1.next();
            int var3 = var2.getIntValue();
            Entity var4 = var0.getEntity((UUID)var2.getKey());
            if (var4 == null) continue;
            this.angerBySuspect.put((Object)var4, var3);
            this.suspects.add(var4);
            var1.remove();
        }
    }

    public int increaseAnger(Entity var0, int var12) {
        boolean var22 = !this.angerBySuspect.containsKey((Object)var0);
        int var3 = this.angerBySuspect.computeInt((Object)var0, (var1, var2) -> Math.min(150, (var2 == null ? 0 : var2) + var12));
        if (var22) {
            int var4 = this.angerByUuid.removeInt((Object)var0.getUUID());
            this.angerBySuspect.put((Object)var0, var3 += var4);
            this.suspects.add(var0);
        }
        this.sortAndUpdateHighestAnger();
        return var3;
    }

    public void clearAnger(Entity var0) {
        this.angerBySuspect.removeInt((Object)var0);
        this.suspects.remove(var0);
        this.sortAndUpdateHighestAnger();
    }

    private @Nullable Entity getTopSuspect() {
        return this.suspects.stream().filter(this.filter).findFirst().orElse(null);
    }

    public int getActiveAnger(@Nullable Entity var0) {
        return var0 == null ? this.highestAnger : this.angerBySuspect.getInt((Object)var0);
    }

    public Optional<EntityLiving> getActiveEntity() {
        return Optional.ofNullable(this.getTopSuspect()).filter(var0 -> var0 instanceof EntityLiving).map(var0 -> (EntityLiving)var0);
    }

    @VisibleForTesting
    protected record a(AngerManagement angerManagement) implements Comparator<Entity>
    {
        @Override
        public int compare(Entity var0, Entity var1) {
            boolean var5;
            if (var0.equals(var1)) {
                return 0;
            }
            int var2 = this.angerManagement.angerBySuspect.getOrDefault((Object)var0, 0);
            int var3 = this.angerManagement.angerBySuspect.getOrDefault((Object)var1, 0);
            this.angerManagement.highestAnger = Math.max(this.angerManagement.highestAnger, Math.max(var2, var3));
            boolean var4 = AngerLevel.byAnger(var2).isAngry();
            if (var4 != (var5 = AngerLevel.byAnger(var3).isAngry())) {
                return var4 ? -1 : 1;
            }
            boolean var6 = var0 instanceof EntityHuman;
            boolean var7 = var1 instanceof EntityHuman;
            if (var6 != var7) {
                return var6 ? -1 : 1;
            }
            return Integer.compare(var3, var2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((Entity)object, (Entity)object2);
        }
    }
}

