/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import java.util.Arrays;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.SystemUtils;

public final class AngerLevel
extends Enum<AngerLevel> {
    public static final /* enum */ AngerLevel CALM = new AngerLevel(0, SoundEffects.WARDEN_AMBIENT, SoundEffects.WARDEN_LISTENING);
    public static final /* enum */ AngerLevel AGITATED = new AngerLevel(40, SoundEffects.WARDEN_AGITATED, SoundEffects.WARDEN_LISTENING_ANGRY);
    public static final /* enum */ AngerLevel ANGRY = new AngerLevel(80, SoundEffects.WARDEN_ANGRY, SoundEffects.WARDEN_LISTENING_ANGRY);
    private static final AngerLevel[] SORTED_LEVELS;
    private final int minimumAnger;
    private final SoundEffect ambientSound;
    private final SoundEffect listeningSound;
    private static final /* synthetic */ AngerLevel[] h;

    public static AngerLevel[] values() {
        return (AngerLevel[])h.clone();
    }

    public static AngerLevel valueOf(String var0) {
        return Enum.valueOf(AngerLevel.class, var0);
    }

    private AngerLevel(int var2, SoundEffect var3, SoundEffect var4) {
        this.minimumAnger = var2;
        this.ambientSound = var3;
        this.listeningSound = var4;
    }

    public int getMinimumAnger() {
        return this.minimumAnger;
    }

    public SoundEffect getAmbientSound() {
        return this.ambientSound;
    }

    public SoundEffect getListeningSound() {
        return this.listeningSound;
    }

    public static AngerLevel byAnger(int var0) {
        for (AngerLevel var4 : SORTED_LEVELS) {
            if (var0 < var4.minimumAnger) continue;
            return var4;
        }
        return CALM;
    }

    public boolean isAngry() {
        return this == ANGRY;
    }

    private static /* synthetic */ AngerLevel[] e() {
        return new AngerLevel[]{CALM, AGITATED, ANGRY};
    }

    static {
        h = AngerLevel.e();
        SORTED_LEVELS = SystemUtils.make(AngerLevel.values(), var02 -> Arrays.sort(var02, (var0, var1) -> Integer.compare(var1.minimumAnger, var0.minimumAnger)));
    }
}

