/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.skeleton;

import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.arrow.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public class Parched
extends EntitySkeletonAbstract {
    public Parched(EntityTypes<? extends EntitySkeletonAbstract> var0, World var1) {
        super(var0, var1);
    }

    @Override
    protected EntityArrow getArrow(ItemStack var0, float var1, @Nullable ItemStack var2) {
        EntityArrow var3 = super.getArrow(var0, var1, var2);
        if (var3 instanceof EntityTippedArrow) {
            ((EntityTippedArrow)var3).addEffect(new MobEffect(MobEffects.WEAKNESS, 600));
        }
        return var3;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntitySkeletonAbstract.createAttributes().add(GenericAttributes.MAX_HEALTH, 16.0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.PARCHED_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PARCHED_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.PARCHED_DEATH;
    }

    @Override
    SoundEffect getStepSound() {
        return SoundEffects.PARCHED_STEP;
    }

    @Override
    protected int getHardAttackInterval() {
        return 50;
    }

    @Override
    protected int getAttackInterval() {
        return 70;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.getEffect() == MobEffects.WEAKNESS) {
            return false;
        }
        return super.canBeAffected(var0);
    }
}

