/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.BreezeWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;

public class Shoot
extends Behavior<Breeze> {
    private static final int ATTACK_RANGE_MAX_SQRT = 256;
    private static final int UNCERTAINTY_BASE = 5;
    private static final int UNCERTAINTY_MULTIPLIER = 4;
    private static final float PROJECTILE_MOVEMENT_SCALE = 0.7f;
    private static final int SHOOT_INITIAL_DELAY_TICKS = Math.round(15.0f);
    private static final int SHOOT_RECOVER_DELAY_TICKS = Math.round(4.0f);
    private static final int SHOOT_COOLDOWN_TICKS = Math.round(10.0f);

    @VisibleForTesting
    public Shoot() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_JUMP_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), SHOOT_INITIAL_DELAY_TICKS + 1 + SHOOT_RECOVER_DELAY_TICKS);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Breeze var12) {
        if (var12.getPose() != EntityPose.STANDING) {
            return false;
        }
        return var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).map(var1 -> Shoot.isTargetWithinRange(var12, var1)).map(var1 -> {
            if (!var1.booleanValue()) {
                var12.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
            }
            return var1;
        }).orElse(false);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Breeze var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && var1.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_SHOOT);
    }

    @Override
    protected void start(WorldServer var0, Breeze var12, long var2) {
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(var1 -> var12.setPose(EntityPose.SHOOTING));
        var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_CHARGING, Unit.INSTANCE, SHOOT_INITIAL_DELAY_TICKS);
        var12.playSound(SoundEffects.BREEZE_INHALE, 1.0f, 1.0f);
    }

    @Override
    protected void stop(WorldServer var0, Breeze var1, long var2) {
        if (var1.getPose() == EntityPose.SHOOTING) {
            var1.setPose(EntityPose.STANDING);
        }
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_COOLDOWN, Unit.INSTANCE, SHOOT_COOLDOWN_TICKS);
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
    }

    @Override
    protected void tick(WorldServer var0, Breeze var1, long var2) {
        BehaviorController<Breeze> var4 = var1.getBrain();
        EntityLiving var5 = var4.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var5 == null) {
            return;
        }
        var1.lookAt(ArgumentAnchor.Anchor.EYES, var5.position());
        if (var4.getMemory(MemoryModuleType.BREEZE_SHOOT_CHARGING).isPresent() || var4.getMemory(MemoryModuleType.BREEZE_SHOOT_RECOVERING).isPresent()) {
            return;
        }
        var4.setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_RECOVERING, Unit.INSTANCE, SHOOT_RECOVER_DELAY_TICKS);
        double var6 = var5.getX() - var1.getX();
        double var8 = var5.getY(var5.isPassenger() ? 0.8 : 0.3) - var1.getFiringYPosition();
        double var10 = var5.getZ() - var1.getZ();
        IProjectile.spawnProjectileUsingShoot(new BreezeWindCharge(var1, (World)var0), var0, ItemStack.EMPTY, var6, var8, var10, 0.7f, 5 - var0.getDifficulty().getId() * 4);
        var1.playSound(SoundEffects.BREEZE_SHOOT, 1.5f, 1.0f);
    }

    private static boolean isTargetWithinRange(Breeze var0, EntityLiving var1) {
        double var2 = var0.position().distanceToSqr(var1.position());
        return var2 < 256.0;
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (Breeze)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (Breeze)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Breeze)entityLiving, l2);
    }
}

