/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Collection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.jspecify.annotations.Nullable;

public class EntityCreeper
extends EntityMonster {
    private static final DataWatcherObject<Integer> DATA_SWELL_DIR = DataWatcher.defineId(EntityCreeper.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_IS_POWERED = DataWatcher.defineId(EntityCreeper.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> DATA_IS_IGNITED = DataWatcher.defineId(EntityCreeper.class, DataWatcherRegistry.BOOLEAN);
    private static final boolean DEFAULT_IGNITED = false;
    private static final boolean DEFAULT_POWERED = false;
    private static final short DEFAULT_MAX_SWELL = 30;
    private static final byte DEFAULT_EXPLOSION_RADIUS = 3;
    private int oldSwell;
    public int swell;
    public int maxSwell = 30;
    public int explosionRadius = 3;
    private boolean droppedSkulls;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new PathfinderGoalSwell(this));
        this.goalSelector.addGoal(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(6, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.targetSelector.addGoal(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public int getMaxFallDistance() {
        if (this.getTarget() == null) {
            return this.getComfortableFallDistance(0.0f);
        }
        return this.getComfortableFallDistance(this.getHealth() - 1.0f);
    }

    @Override
    public boolean causeFallDamage(double var0, float var2, DamageSource var3) {
        boolean var4 = super.causeFallDamage(var0, var2, var3);
        this.swell += (int)(var0 * 1.5);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return var4;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_SWELL_DIR, -1);
        var0.define(DATA_IS_POWERED, false);
        var0.define(DATA_IS_IGNITED, false);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("powered", this.isPowered());
        var0.putShort("Fuse", (short)this.maxSwell);
        var0.putByte("ExplosionRadius", (byte)this.explosionRadius);
        var0.putBoolean("ignited", this.isIgnited());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.entityData.set(DATA_IS_POWERED, var0.getBooleanOr("powered", false));
        this.maxSwell = var0.getShortOr("Fuse", (short)30);
        this.explosionRadius = var0.getByteOr("ExplosionRadius", (byte)3);
        if (var0.getBooleanOr("ignited", false)) {
            this.ignite();
        }
    }

    @Override
    public void tick() {
        if (this.isAlive()) {
            int var0;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((var0 = this.getSwellDir()) > 0 && this.swell == 0) {
                this.playSound(SoundEffects.CREEPER_PRIMED, 1.0f, 0.5f);
                this.gameEvent(GameEvent.PRIME_FUSE);
            }
            this.swell += var0;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.tick();
    }

    @Override
    public void setTarget(@Nullable EntityLiving var0) {
        if (var0 instanceof Goat) {
            return;
        }
        super.setTarget(var0);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.CREEPER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.CREEPER_DEATH;
    }

    @Override
    public boolean killedEntity(WorldServer var0, EntityLiving var1, DamageSource var22) {
        if (this.shouldDropLoot(var0) && this.isPowered() && !this.droppedSkulls) {
            var1.dropFromLootTable(var0, var22, false, LootTables.CHARGED_CREEPER, var2 -> {
                var1.spawnAtLocation(var0, (ItemStack)var2);
                this.droppedSkulls = true;
            });
        }
        return super.killedEntity(var0, var1, var22);
    }

    @Override
    public boolean doHurtTarget(WorldServer var0, Entity var1) {
        return true;
    }

    public boolean isPowered() {
        return this.entityData.get(DATA_IS_POWERED);
    }

    public float getSwelling(float var0) {
        return MathHelper.lerp(var0, this.oldSwell, this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return this.entityData.get(DATA_SWELL_DIR);
    }

    public void setSwellDir(int var0) {
        this.entityData.set(DATA_SWELL_DIR, var0);
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        super.thunderHit(var0, var1);
        this.entityData.set(DATA_IS_POWERED, true);
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.is(TagsItem.CREEPER_IGNITERS)) {
            SoundEffect var3 = var2.is(Items.FIRE_CHARGE) ? SoundEffects.FIRECHARGE_USE : SoundEffects.FLINTANDSTEEL_USE;
            this.level().playSound((Entity)var0, this.getX(), this.getY(), this.getZ(), var3, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide()) {
                this.ignite();
                if (!var2.isDamageableItem()) {
                    var2.shrink(1);
                } else {
                    var2.hurtAndBreak(1, (EntityLiving)var0, var1.asEquipmentSlot());
                }
            }
            return EnumInteractionResult.SUCCESS;
        }
        return super.mobInteract(var0, var1);
    }

    public void explodeCreeper() {
        World world = this.level();
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            float var1 = this.isPowered() ? 2.0f : 1.0f;
            this.dead = true;
            var0.explode(this, this.getX(), this.getY(), this.getZ(), (float)this.explosionRadius * var1, World.a.MOB);
            this.spawnLingeringCloud();
            this.triggerOnDeathMobEffects(var0, Entity.RemovalReason.KILLED);
            this.discard();
        }
    }

    private void spawnLingeringCloud() {
        Collection<MobEffect> var0 = this.getActiveEffects();
        if (!var0.isEmpty()) {
            EntityAreaEffectCloud var1 = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            var1.setRadius(2.5f);
            var1.setRadiusOnUse(-0.5f);
            var1.setWaitTime(10);
            var1.setDuration(300);
            var1.setPotionDurationScale(0.25f);
            var1.setRadiusPerTick(-var1.getRadius() / (float)var1.getDuration());
            for (MobEffect var3 : var0) {
                var1.addEffect(new MobEffect(var3));
            }
            this.level().addFreshEntity(var1);
        }
    }

    public boolean isIgnited() {
        return this.entityData.get(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.entityData.set(DATA_IS_IGNITED, true);
    }
}

