/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.WindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityWither
extends EntityMonster
implements IRangedEntity {
    private static final DataWatcherObject<Integer> DATA_TARGET_A = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_B = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_C = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final List<DataWatcherObject<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final DataWatcherObject<Integer> DATA_ID_INV = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private static final int DEFAULT_INVULNERABLE_TICKS = 0;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    public final BossBattleServer bossEvent = (BossBattleServer)new BossBattleServer(this.getDisplayName(), BossBattle.BarColor.PURPLE, BossBattle.BarStyle.PROGRESS).setDarkenScreen(true);
    private static final PathfinderTargetCondition.a LIVING_ENTITY_SELECTOR = (var0, var1) -> !var0.getType().is(TagsEntity.WITHER_FRIENDS) && var0.attackable();
    private static final PathfinderTargetCondition TARGETING_CONDITIONS = PathfinderTargetCondition.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);

    public EntityWither(EntityTypes<? extends EntityWither> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0);
        var1.setCanOpenDoors(false);
        var1.setCanFloat(true);
        return var1;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new a());
        this.goalSelector.addGoal(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomFly(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_TARGET_A, 0);
        var0.define(DATA_TARGET_B, 0);
        var0.define(DATA_TARGET_C, 0);
        var0.define(DATA_ID_INV, 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Invul", this.getInvulnerableTicks());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setInvulnerableTicks(var0.getIntOr("Invul", 0));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomName(@Nullable IChatBaseComponent var0) {
        super.setCustomName(var0);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITHER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WITHER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        int var1;
        Entity var12;
        Vec3D var0 = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level().isClientSide() && this.getAlternativeTarget(0) > 0 && (var12 = this.level().getEntity(this.getAlternativeTarget(0))) != null) {
            double var2 = var0.y;
            if (this.getY() < var12.getY() || !this.isPowered() && this.getY() < var12.getY() + 5.0) {
                var2 = Math.max(0.0, var2);
                var2 += 0.3 - var2 * (double)0.6f;
            }
            var0 = new Vec3D(var0.x, var2, var0.z);
            Vec3D var4 = new Vec3D(var12.getX() - this.getX(), 0.0, var12.getZ() - this.getZ());
            if (var4.horizontalDistanceSqr() > 9.0) {
                Vec3D var5 = var4.normalize();
                var0 = var0.add(var5.x * 0.3 - var0.x * 0.6, 0.0, var5.z * 0.3 - var0.z * 0.6);
            }
        }
        this.setDeltaMovement(var0);
        if (var0.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)MathHelper.atan2(var0.z, var0.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (var1 = 0; var1 < 2; ++var1) {
            this.yRotOHeads[var1] = this.yRotHeads[var1];
            this.xRotOHeads[var1] = this.xRotHeads[var1];
        }
        for (var1 = 0; var1 < 2; ++var1) {
            int var2 = this.getAlternativeTarget(var1 + 1);
            Entity var3 = null;
            if (var2 > 0) {
                var3 = this.level().getEntity(var2);
            }
            if (var3 != null) {
                double var4 = this.getHeadX(var1 + 1);
                double var6 = this.getHeadY(var1 + 1);
                double var8 = this.getHeadZ(var1 + 1);
                double var10 = var3.getX() - var4;
                double var122 = var3.getEyeY() - var6;
                double var14 = var3.getZ() - var8;
                double var16 = Math.sqrt(var10 * var10 + var14 * var14);
                float var18 = (float)(MathHelper.atan2(var14, var10) * 57.2957763671875) - 90.0f;
                float var19 = (float)(-(MathHelper.atan2(var122, var16) * 57.2957763671875));
                this.xRotHeads[var1] = this.rotlerp(this.xRotHeads[var1], var19, 40.0f);
                this.yRotHeads[var1] = this.rotlerp(this.yRotHeads[var1], var18, 10.0f);
                continue;
            }
            this.yRotHeads[var1] = this.rotlerp(this.yRotHeads[var1], this.yBodyRot, 10.0f);
        }
        var1 = this.isPowered() ? 1 : 0;
        for (int var2 = 0; var2 < 3; ++var2) {
            double var3 = this.getHeadX(var2);
            double var5 = this.getHeadY(var2);
            double var7 = this.getHeadZ(var2);
            float var9 = 0.3f * this.getScale();
            this.level().addParticle(Particles.SMOKE, var3 + this.random.nextGaussian() * (double)var9, var5 + this.random.nextGaussian() * (double)var9, var7 + this.random.nextGaussian() * (double)var9, 0.0, 0.0, 0.0);
            if (var1 == 0 || this.level().random.nextInt(4) != 0) continue;
            this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, 0.7f, 0.7f, 0.5f), var3 + this.random.nextGaussian() * (double)var9, var5 + this.random.nextGaussian() * (double)var9, var7 + this.random.nextGaussian() * (double)var9, 0.0, 0.0, 0.0);
        }
        if (this.getInvulnerableTicks() > 0) {
            float var2 = 3.3f * this.getScale();
            for (int var3 = 0; var3 < 3; ++var3) {
                this.level().addParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, 0.7f, 0.7f, 0.9f), this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * var2), this.getZ() + this.random.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        int var2;
        int var1;
        if (this.getInvulnerableTicks() > 0) {
            int var12 = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)var12 / 220.0f);
            if (var12 <= 0) {
                var0.explode((Entity)this, this.getX(), this.getEyeY(), this.getZ(), 7.0f, false, World.a.MOB);
                if (!this.isSilent()) {
                    var0.globalLevelEvent(1023, this.blockPosition(), 0);
                }
            }
            this.setInvulnerableTicks(var12);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f);
            }
            return;
        }
        super.customServerAiStep(var0);
        for (var1 = 1; var1 < 3; ++var1) {
            List<EntityLiving> var3;
            if (this.tickCount < this.nextHeadUpdate[var1 - 1]) continue;
            this.nextHeadUpdate[var1 - 1] = this.tickCount + 10 + this.random.nextInt(10);
            if (var0.getDifficulty() == EnumDifficulty.NORMAL || var0.getDifficulty() == EnumDifficulty.HARD) {
                int n2 = var1 - 1;
                int n3 = this.idleHeadUpdates[n2];
                this.idleHeadUpdates[n2] = n3 + 1;
                if (n3 > 15) {
                    float var22 = 10.0f;
                    float var32 = 5.0f;
                    double var4 = MathHelper.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                    double var6 = MathHelper.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                    double var8 = MathHelper.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                    this.performRangedAttack(var1 + 1, var4, var6, var8, true);
                    this.idleHeadUpdates[var1 - 1] = 0;
                }
            }
            if ((var2 = this.getAlternativeTarget(var1)) > 0) {
                var3 = (EntityLiving)var0.getEntity(var2);
                if (var3 == null || !this.canAttack((EntityLiving)((Object)var3)) || this.distanceToSqr((Entity)((Object)var3)) > 900.0 || !this.hasLineOfSight((Entity)((Object)var3))) {
                    this.setAlternativeTarget(var1, 0);
                    continue;
                }
                this.performRangedAttack(var1 + 1, (EntityLiving)((Object)var3));
                this.nextHeadUpdate[var1 - 1] = this.tickCount + 40 + this.random.nextInt(20);
                this.idleHeadUpdates[var1 - 1] = 0;
                continue;
            }
            var3 = var0.getNearbyEntities(EntityLiving.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
            if (var3.isEmpty()) continue;
            EntityLiving var4 = (EntityLiving)var3.get(this.random.nextInt(var3.size()));
            this.setAlternativeTarget(var1, var4.getId());
        }
        if (this.getTarget() != null) {
            this.setAlternativeTarget(0, this.getTarget().getId());
        } else {
            this.setAlternativeTarget(0, 0);
        }
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && var0.getGameRules().get(GameRules.MOB_GRIEFING).booleanValue()) {
                var1 = 0;
                var2 = MathHelper.floor(this.getBbWidth() / 2.0f + 1.0f);
                int var3 = MathHelper.floor(this.getBbHeight());
                for (BlockPosition var5 : BlockPosition.betweenClosed(this.getBlockX() - var2, this.getBlockY(), this.getBlockZ() - var2, this.getBlockX() + var2, this.getBlockY() + var3, this.getBlockZ() + var2)) {
                    IBlockData var6 = var0.getBlockState(var5);
                    if (!EntityWither.canDestroy(var6)) continue;
                    var1 = var0.destroyBlock(var5, true, this) || var1 != 0 ? 1 : 0;
                }
                if (var1 != 0) {
                    var0.levelEvent(null, 1022, this.blockPosition(), 0);
                }
            }
        }
        if (this.tickCount % 20 == 0) {
            this.heal(1.0f);
        }
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static boolean canDestroy(IBlockData var0) {
        return !var0.isAir() && !var0.is(TagsBlock.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
    }

    @Override
    public void startSeenByPlayer(EntityPlayer var0) {
        super.startSeenByPlayer(var0);
        this.bossEvent.addPlayer(var0);
    }

    @Override
    public void stopSeenByPlayer(EntityPlayer var0) {
        super.stopSeenByPlayer(var0);
        this.bossEvent.removePlayer(var0);
    }

    private double getHeadX(int var0) {
        if (var0 <= 0) {
            return this.getX();
        }
        float var1 = (this.yBodyRot + (float)(180 * (var0 - 1))) * ((float)Math.PI / 180);
        float var2 = MathHelper.cos(var1);
        return this.getX() + (double)var2 * 1.3 * (double)this.getScale();
    }

    private double getHeadY(int var0) {
        float var1 = var0 <= 0 ? 3.0f : 2.2f;
        return this.getY() + (double)(var1 * this.getScale());
    }

    private double getHeadZ(int var0) {
        if (var0 <= 0) {
            return this.getZ();
        }
        float var1 = (this.yBodyRot + (float)(180 * (var0 - 1))) * ((float)Math.PI / 180);
        float var2 = MathHelper.sin(var1);
        return this.getZ() + (double)var2 * 1.3 * (double)this.getScale();
    }

    private float rotlerp(float var0, float var1, float var2) {
        float var3 = MathHelper.wrapDegrees(var1 - var0);
        if (var3 > var2) {
            var3 = var2;
        }
        if (var3 < -var2) {
            var3 = -var2;
        }
        return var0 + var3;
    }

    private void performRangedAttack(int var0, EntityLiving var1) {
        this.performRangedAttack(var0, var1.getX(), var1.getY() + (double)var1.getEyeHeight() * 0.5, var1.getZ(), var0 == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int var0, double var1, double var3, double var5, boolean var7) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double var8 = this.getHeadX(var0);
        double var10 = this.getHeadY(var0);
        double var12 = this.getHeadZ(var0);
        double var14 = var1 - var8;
        double var16 = var3 - var10;
        double var18 = var5 - var12;
        Vec3D var20 = new Vec3D(var14, var16, var18);
        EntityWitherSkull var21 = new EntityWitherSkull(this.level(), this, var20.normalize());
        var21.setOwner(this);
        if (var7) {
            var21.setDangerous(true);
        }
        var21.setPos(var8, var10, var12);
        this.level().addFreshEntity(var21);
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.performRangedAttack(0, var0);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        Entity var3;
        if (this.isInvulnerableTo(var0, var1)) {
            return false;
        }
        if (var1.is(DamageTypeTags.WITHER_IMMUNE_TO) || var1.getEntity() instanceof EntityWither) {
            return false;
        }
        if (this.getInvulnerableTicks() > 0 && !var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (this.isPowered() && ((var3 = var1.getDirectEntity()) instanceof EntityArrow || var3 instanceof WindCharge)) {
            return false;
        }
        var3 = var1.getEntity();
        if (var3 != null && var3.getType().is(TagsEntity.WITHER_FRIENDS)) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        int var4 = 0;
        while (var4 < this.idleHeadUpdates.length) {
            int n2 = var4++;
            this.idleHeadUpdates[n2] = this.idleHeadUpdates[n2] + 3;
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    protected void dropCustomDeathLoot(WorldServer var0, DamageSource var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        EntityItem var3 = this.spawnAtLocation(var0, Items.NETHER_STAR);
        if (var3 != null) {
            var3.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level().getDifficulty() == EnumDifficulty.PEACEFUL && !this.getType().isAllowedInPeaceful()) {
            this.discard();
            return;
        }
        this.noActionTime = 0;
    }

    @Override
    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        return false;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 300.0).add(GenericAttributes.MOVEMENT_SPEED, 0.6f).add(GenericAttributes.FLYING_SPEED, 0.6f).add(GenericAttributes.FOLLOW_RANGE, 40.0).add(GenericAttributes.ARMOR, 4.0);
    }

    public float[] getHeadYRots() {
        return this.yRotHeads;
    }

    public float[] getHeadXRots() {
        return this.xRotHeads;
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int var0) {
        this.entityData.set(DATA_ID_INV, var0);
    }

    public int getAlternativeTarget(int var0) {
        return this.entityData.get(DATA_TARGETS.get(var0));
    }

    public void setAlternativeTarget(int var0, int var1) {
        this.entityData.set(DATA_TARGETS.get(var0), var1);
    }

    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    @Override
    public boolean canUsePortal(boolean var0) {
        return false;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.is(MobEffects.WITHER)) {
            return false;
        }
        return super.canBeAffected(var0);
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityWither.this.getInvulnerableTicks() > 0;
        }
    }
}

