/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DragonControllerManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EntityEnderDragon dragon;
    private final @Nullable IDragonController[] phases = new IDragonController[DragonControllerPhase.getCount()];
    private @Nullable IDragonController currentPhase;

    public DragonControllerManager(EntityEnderDragon var0) {
        this.dragon = var0;
        this.setPhase(DragonControllerPhase.HOVERING);
    }

    public void setPhase(DragonControllerPhase<?> var0) {
        if (this.currentPhase != null && var0 == this.currentPhase.getPhase()) {
            return;
        }
        if (this.currentPhase != null) {
            this.currentPhase.end();
        }
        this.currentPhase = this.getPhase(var0);
        if (!this.dragon.level().isClientSide()) {
            this.dragon.getEntityData().set(EntityEnderDragon.DATA_PHASE, var0.getId());
        }
        LOGGER.debug("Dragon is now in phase {} on the {}", var0, (Object)(this.dragon.level().isClientSide() ? "client" : "server"));
        this.currentPhase.begin();
    }

    public IDragonController getCurrentPhase() {
        return Objects.requireNonNull(this.currentPhase);
    }

    public <T extends IDragonController> T getPhase(DragonControllerPhase<T> var0) {
        int var1 = var0.getId();
        IDragonController var2 = this.phases[var1];
        if (var2 == null) {
            this.phases[var1] = var2 = var0.createInstance(this.dragon);
        }
        return (T)var2;
    }
}

