/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusAi;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariants;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class ZombieNautilus
extends AbstractNautilus {
    private static final DataWatcherObject<Holder<ZombieNautilusVariant>> DATA_VARIANT_ID = DataWatcher.defineId(ZombieNautilus.class, DataWatcherRegistry.ZOMBIE_NAUTILUS_VARIANT);

    public ZombieNautilus(EntityTypes<? extends ZombieNautilus> var0, World var1) {
        super((EntityTypes<? extends AbstractNautilus>)var0, var1);
    }

    public static AttributeProvider.Builder createAttributes() {
        return AbstractNautilus.createAttributes().add(GenericAttributes.MOVEMENT_SPEED, 1.1f);
    }

    @Override
    public @Nullable ZombieNautilus getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    @Override
    protected EnumItemSlot sunProtectionSlot() {
        return EnumItemSlot.BODY;
    }

    protected BehaviorController.b<ZombieNautilus> brainProvider() {
        return ZombieNautilusAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return ZombieNautilusAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<ZombieNautilus> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("zombieNautilusBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("zombieNautilusActivityUpdate");
        ZombieNautilusAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.isUnderWater() ? SoundEffects.ZOMBIE_NAUTILUS_AMBIENT : SoundEffects.ZOMBIE_NAUTILUS_AMBIENT_ON_LAND;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return this.isUnderWater() ? SoundEffects.ZOMBIE_NAUTILUS_HURT : SoundEffects.ZOMBIE_NAUTILUS_HURT_ON_LAND;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return this.isUnderWater() ? SoundEffects.ZOMBIE_NAUTILUS_DEATH : SoundEffects.ZOMBIE_NAUTILUS_DEATH_ON_LAND;
    }

    @Override
    protected SoundEffect getDashSound() {
        return this.isUnderWater() ? SoundEffects.ZOMBIE_NAUTILUS_DASH : SoundEffects.ZOMBIE_NAUTILUS_DASH_ON_LAND;
    }

    @Override
    protected SoundEffect getDashReadySound() {
        return this.isUnderWater() ? SoundEffects.ZOMBIE_NAUTILUS_DASH_READY : SoundEffects.ZOMBIE_NAUTILUS_DASH_READY_ON_LAND;
    }

    @Override
    protected void playEatingSound() {
        this.makeSound(SoundEffects.ZOMBIE_NAUTILUS_EAT);
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.ZOMBIE_NAUTILUS_SWIM;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), ZombieNautilusVariants.TEMPERATE));
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        VariantUtils.readVariant(var0, Registries.ZOMBIE_NAUTILUS_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        VariantUtils.writeVariant(var0, this.getVariant());
    }

    public void setVariant(Holder<ZombieNautilusVariant> var0) {
        this.entityData.set(DATA_VARIANT_ID, var0);
    }

    public Holder<ZombieNautilusVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.ZOMBIE_NAUTILUS_VARIANT) {
            return ZombieNautilus.castComponentValue(var0, new EitherHolder<ZombieNautilusVariant>(this.getVariant()));
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.ZOMBIE_NAUTILUS_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.ZOMBIE_NAUTILUS_VARIANT) {
            Optional<Holder<ZombieNautilusVariant>> var2 = ZombieNautilus.castComponentValue(DataComponents.ZOMBIE_NAUTILUS_VARIANT, var1).unwrap(this.registryAccess());
            if (var2.isPresent()) {
                this.setVariant(var2.get());
                return true;
            }
            return false;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(var0, this.blockPosition()), Registries.ZOMBIE_NAUTILUS_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAggravated() && !this.isMobControlled();
    }

    @Override
    public boolean isBaby() {
        return false;
    }

    @Override
    public /* synthetic */ @Nullable EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

