/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.nautilus;

import com.mojang.serialization.Dynamic;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.NautilusAi;
import net.minecraft.world.level.World;
import org.jspecify.annotations.Nullable;

public class Nautilus
extends AbstractNautilus {
    private static final int NAUTILUS_TOTAL_AIR_SUPPLY = 300;

    public Nautilus(EntityTypes<? extends Nautilus> var0, World var1) {
        super((EntityTypes<? extends AbstractNautilus>)var0, var1);
    }

    protected BehaviorController.b<Nautilus> brainProvider() {
        return NautilusAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return NautilusAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Nautilus> getBrain() {
        return super.getBrain();
    }

    @Override
    public @Nullable Nautilus getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        Nautilus var2 = EntityTypes.NAUTILUS.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null && this.isTame()) {
            var2.setOwnerReference(this.getOwnerReference());
            var2.setTame(true, true);
        }
        return var2;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("nautilusBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("nautilusActivityUpdate");
        NautilusAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    protected SoundEffect getAmbientSound() {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEffects.BABY_NAUTILUS_AMBIENT : SoundEffects.BABY_NAUTILUS_AMBIENT_ON_LAND;
        }
        return this.isUnderWater() ? SoundEffects.NAUTILUS_AMBIENT : SoundEffects.NAUTILUS_AMBIENT_ON_LAND;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEffects.BABY_NAUTILUS_HURT : SoundEffects.BABY_NAUTILUS_HURT_ON_LAND;
        }
        return this.isUnderWater() ? SoundEffects.NAUTILUS_HURT : SoundEffects.NAUTILUS_HURT_ON_LAND;
    }

    @Override
    protected SoundEffect getDeathSound() {
        if (this.isBaby()) {
            return this.isUnderWater() ? SoundEffects.BABY_NAUTILUS_DEATH : SoundEffects.BABY_NAUTILUS_DEATH_ON_LAND;
        }
        return this.isUnderWater() ? SoundEffects.NAUTILUS_DEATH : SoundEffects.NAUTILUS_DEATH_ON_LAND;
    }

    @Override
    protected SoundEffect getDashSound() {
        return this.isUnderWater() ? SoundEffects.NAUTILUS_DASH : SoundEffects.NAUTILUS_DASH_ON_LAND;
    }

    @Override
    protected SoundEffect getDashReadySound() {
        return this.isUnderWater() ? SoundEffects.NAUTILUS_DASH_READY : SoundEffects.NAUTILUS_DASH_READY_ON_LAND;
    }

    @Override
    protected void playEatingSound() {
        SoundEffect var0 = this.isBaby() ? SoundEffects.BABY_NAUTILUS_EAT : SoundEffects.NAUTILUS_EAT;
        this.makeSound(var0);
    }

    @Override
    protected SoundEffect getSwimSound() {
        return this.isBaby() ? SoundEffects.BABY_NAUTILUS_SWIM : SoundEffects.NAUTILUS_SWIM;
    }

    @Override
    public int getMaxAirSupply() {
        return 300;
    }

    protected void handleAirSupply(WorldServer var0, int var1) {
        if (this.isAlive() && !this.isInWater()) {
            this.setAirSupply(var1 - 1);
            if (this.getAirSupply() <= -20) {
                this.setAirSupply(0);
                this.hurtServer(var0, this.damageSources().dryOut(), 2.0f);
            }
        } else {
            this.setAirSupply(300);
        }
    }

    @Override
    public void baseTick() {
        World world;
        int var0 = this.getAirSupply();
        super.baseTick();
        if (!this.isNoAi() && (world = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.handleAirSupply(var1, var0);
        }
    }

    @Override
    public boolean canBeLeashed() {
        return !this.isAggravated();
    }

    @Override
    public /* synthetic */ @Nullable EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

