/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.golem;

import com.mojang.serialization.Dynamic;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.golem.CopperGolemAi;
import net.minecraft.world.entity.animal.golem.CopperGolemOxidationLevels;
import net.minecraft.world.entity.animal.golem.CopperGolemState;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.CopperGolemStatueBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class CopperGolem
extends EntityGolem
implements ContainerUser,
IShearable {
    private static final long IGNORE_WEATHERING_TICK = -2L;
    private static final long UNSET_WEATHERING_TICK = -1L;
    private static final int WEATHERING_TICK_FROM = 504000;
    private static final int WEATHERING_TICK_TO = 552000;
    private static final int SPIN_ANIMATION_MIN_COOLDOWN = 200;
    private static final int SPIN_ANIMATION_MAX_COOLDOWN = 240;
    private static final float SPIN_SOUND_TIME_INTERVAL_OFFSET = 10.0f;
    private static final float TURN_TO_STATUE_CHANCE = 0.0058f;
    private static final int SPAWN_COOLDOWN_MIN = 60;
    private static final int SPAWN_COOLDOWN_MAX = 100;
    private static final DataWatcherObject<WeatheringCopper.a> DATA_WEATHER_STATE = DataWatcher.defineId(CopperGolem.class, DataWatcherRegistry.WEATHERING_COPPER_STATE);
    private static final DataWatcherObject<CopperGolemState> COPPER_GOLEM_STATE = DataWatcher.defineId(CopperGolem.class, DataWatcherRegistry.COPPER_GOLEM_STATE);
    private @Nullable BlockPosition openedChestPos;
    private @Nullable UUID lastLightningBoltUUID;
    public long nextWeatheringTick = -1L;
    private int idleAnimationStartTick = 0;
    private final AnimationState idleAnimationState = new AnimationState();
    private final AnimationState interactionGetItemAnimationState = new AnimationState();
    private final AnimationState interactionGetNoItemAnimationState = new AnimationState();
    private final AnimationState interactionDropItemAnimationState = new AnimationState();
    private final AnimationState interactionDropNoItemAnimationState = new AnimationState();
    public static final EnumItemSlot EQUIPMENT_SLOT_ANTENNA = EnumItemSlot.SADDLE;

    public CopperGolem(EntityTypes<? extends EntityGolem> var0, World var1) {
        super(var0, var1);
        this.getNavigation().setRequiredPathLength(48.0f);
        this.getNavigation().setCanOpenDoors(true);
        this.setPersistenceRequired();
        this.setState(CopperGolemState.IDLE);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_OTHER, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.getBrain().setMemory(MemoryModuleType.TRANSPORT_ITEMS_COOLDOWN_TICKS, this.getRandom().nextInt(60, 100));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.2f).add(GenericAttributes.STEP_HEIGHT, 1.0).add(GenericAttributes.MAX_HEALTH, 12.0);
    }

    public CopperGolemState getState() {
        return this.entityData.get(COPPER_GOLEM_STATE);
    }

    public void setState(CopperGolemState var0) {
        this.entityData.set(COPPER_GOLEM_STATE, var0);
    }

    public WeatheringCopper.a getWeatherState() {
        return this.entityData.get(DATA_WEATHER_STATE);
    }

    public void setWeatherState(WeatheringCopper.a var0) {
        this.entityData.set(DATA_WEATHER_STATE, var0);
    }

    public void setOpenedChestPos(BlockPosition var0) {
        this.openedChestPos = var0;
    }

    public void clearOpenedChestPos() {
        this.openedChestPos = null;
    }

    public AnimationState getIdleAnimationState() {
        return this.idleAnimationState;
    }

    public AnimationState getInteractionGetItemAnimationState() {
        return this.interactionGetItemAnimationState;
    }

    public AnimationState getInteractionGetNoItemAnimationState() {
        return this.interactionGetNoItemAnimationState;
    }

    public AnimationState getInteractionDropItemAnimationState() {
        return this.interactionDropItemAnimationState;
    }

    public AnimationState getInteractionDropNoItemAnimationState() {
        return this.interactionDropNoItemAnimationState;
    }

    protected BehaviorController.b<CopperGolem> brainProvider() {
        return CopperGolemAi.brainProvider();
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return CopperGolemAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<CopperGolem> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_WEATHER_STATE, WeatheringCopper.a.UNAFFECTED);
        var0.define(COPPER_GOLEM_STATE, CopperGolemState.IDLE);
    }

    @Override
    public void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putLong("next_weather_age", this.nextWeatheringTick);
        var0.store("weather_state", WeatheringCopper.a.CODEC, this.getWeatherState());
    }

    @Override
    public void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.nextWeatheringTick = var0.getLongOr("next_weather_age", -1L);
        this.setWeatherState(var0.read("weather_state", WeatheringCopper.a.CODEC).orElse(WeatheringCopper.a.UNAFFECTED));
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("copperGolemBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("copperGolemActivityUpdate");
        CopperGolemAi.updateActivity(this);
        var1.pop();
        super.customServerAiStep(var0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (!this.isNoAi()) {
                this.setupAnimationStates();
            }
        } else {
            this.updateWeathering((WorldServer)this.level(), this.level().getRandom(), this.level().getGameTime());
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        WeatheringCopper.a var4;
        Object var3;
        ItemStack var2 = var0.getItemInHand(var1);
        if (var2.isEmpty() && !((ItemStack)(var3 = this.getMainHandItem())).isEmpty()) {
            BehaviorUtil.throwItem(this, (ItemStack)var3, var0.position());
            this.setItemInHand(EnumHand.MAIN_HAND, ItemStack.EMPTY);
            return EnumInteractionResult.SUCCESS;
        }
        var3 = this.level();
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            if (var3 instanceof WorldServer) {
                WorldServer var42 = (WorldServer)var3;
                this.shear(var42, SoundCategory.PLAYERS, var2);
                this.gameEvent(GameEvent.SHEAR, var0);
                var2.hurtAndBreak(1, (EntityLiving)var0, var1);
            }
            return EnumInteractionResult.SUCCESS;
        }
        if (((World)var3).isClientSide()) {
            return EnumInteractionResult.PASS;
        }
        if (var2.is(Items.HONEYCOMB) && this.nextWeatheringTick != -2L) {
            var3.levelEvent(this, 3003, this.blockPosition(), 0);
            this.nextWeatheringTick = -2L;
            this.usePlayerItem(var0, var1, var2);
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        if (var2.is(TagsItem.AXES) && this.nextWeatheringTick == -2L) {
            ((World)var3).playSound(null, this, SoundEffects.AXE_SCRAPE, this.getSoundSource(), 1.0f, 1.0f);
            var3.levelEvent(this, 3004, this.blockPosition(), 0);
            this.nextWeatheringTick = -1L;
            var2.hurtAndBreak(1, (EntityLiving)var0, var1.asEquipmentSlot());
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        if (var2.is(TagsItem.AXES) && (var4 = this.getWeatherState()) != WeatheringCopper.a.UNAFFECTED) {
            ((World)var3).playSound(null, this, SoundEffects.AXE_SCRAPE, this.getSoundSource(), 1.0f, 1.0f);
            var3.levelEvent(this, 3005, this.blockPosition(), 0);
            this.nextWeatheringTick = -1L;
            this.entityData.set(DATA_WEATHER_STATE, var4.previous(), true);
            var2.hurtAndBreak(1, (EntityLiving)var0, var1.asEquipmentSlot());
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(var0, var1);
    }

    private void updateWeathering(WorldServer var0, RandomSource var1, long var2) {
        if (this.nextWeatheringTick == -2L) {
            return;
        }
        if (this.nextWeatheringTick == -1L) {
            this.nextWeatheringTick = var2 + (long)var1.nextIntBetweenInclusive(504000, 552000);
            return;
        }
        WeatheringCopper.a var4 = this.entityData.get(DATA_WEATHER_STATE);
        boolean var5 = var4.equals(WeatheringCopper.a.OXIDIZED);
        if (var2 >= this.nextWeatheringTick && !var5) {
            WeatheringCopper.a var6 = var4.next();
            boolean var7 = var6.equals(WeatheringCopper.a.OXIDIZED);
            this.setWeatherState(var6);
            long l2 = this.nextWeatheringTick = var7 ? 0L : this.nextWeatheringTick + (long)var1.nextIntBetweenInclusive(504000, 552000);
        }
        if (var5 && this.canTurnToStatue(var0)) {
            this.turnToStatue(var0);
        }
    }

    private boolean canTurnToStatue(World var0) {
        return var0.getBlockState(this.blockPosition()).isAir() && var0.random.nextFloat() <= 0.0058f;
    }

    private void turnToStatue(WorldServer var0) {
        BlockPosition var1 = this.blockPosition();
        var0.setBlock(var1, (IBlockData)((IBlockData)Blocks.OXIDIZED_COPPER_GOLEM_STATUE.defaultBlockState().setValue(CopperGolemStatueBlock.POSE, CopperGolemStatueBlock.a.values()[this.random.nextInt(0, CopperGolemStatueBlock.a.values().length)])).setValue(CopperGolemStatueBlock.FACING, EnumDirection.fromYRot(this.getYRot())), 3);
        TileEntity tileEntity = var0.getBlockEntity(var1);
        if (tileEntity instanceof CopperGolemStatueBlockEntity) {
            CopperGolemStatueBlockEntity var2 = (CopperGolemStatueBlockEntity)tileEntity;
            var2.createStatue(this);
            this.dropPreservedEquipment(var0);
            this.discard();
            this.playSound(SoundEffects.COPPER_GOLEM_BECOME_STATUE);
            if (this.isLeashed()) {
                if (var0.getGameRules().get(GameRules.ENTITY_DROPS).booleanValue()) {
                    this.dropLeash();
                } else {
                    this.removeLeash();
                }
            }
        }
    }

    private void setupAnimationStates() {
        switch (this.getState()) {
            case IDLE: {
                this.interactionGetNoItemAnimationState.stop();
                this.interactionGetItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                if (this.idleAnimationStartTick == this.tickCount) {
                    this.idleAnimationState.start(this.tickCount);
                } else if (this.idleAnimationStartTick == 0) {
                    this.idleAnimationStartTick = this.tickCount + this.random.nextInt(200, 240);
                }
                if ((float)this.tickCount != (float)this.idleAnimationStartTick + 10.0f) break;
                this.playHeadSpinSound();
                this.idleAnimationStartTick = 0;
                break;
            }
            case GETTING_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.interactionGetItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case GETTING_NO_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case DROPPING_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case DROPPING_NO_ITEM: {
                this.idleAnimationState.stop();
                this.idleAnimationStartTick = 0;
                this.interactionGetItemAnimationState.stop();
                this.interactionGetNoItemAnimationState.stop();
                this.interactionDropItemAnimationState.stop();
                this.interactionDropNoItemAnimationState.startIfStopped(this.tickCount);
            }
        }
    }

    public void spawn(WeatheringCopper.a var0) {
        this.setWeatherState(var0);
        this.playSpawnSound();
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        this.playSpawnSound();
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public void playSpawnSound() {
        this.playSound(SoundEffects.COPPER_GOLEM_SPAWN);
    }

    private void playHeadSpinSound() {
        if (!this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSpinHeadSound(), this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).hurtSound();
    }

    @Override
    protected SoundEffect getDeathSound() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).deathSound();
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).stepSound(), 1.0f, 1.0f);
    }

    private SoundEffect getSpinHeadSound() {
        return CopperGolemOxidationLevels.getOxidationLevel(this.getWeatherState()).spinHeadSound();
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.75f * this.getEyeHeight(), 0.0);
    }

    @Override
    public boolean hasContainerOpen(ContainerOpenersCounter var0, BlockPosition var1) {
        if (this.openedChestPos == null) {
            return false;
        }
        IBlockData var2 = this.level().getBlockState(this.openedChestPos);
        return this.openedChestPos.equals(var1) || var2.getBlock() instanceof BlockChest && var2.getValue(BlockChest.TYPE) != BlockPropertyChestType.SINGLE && BlockChest.getConnectedBlockPos(this.openedChestPos, var2).equals(var1);
    }

    @Override
    public double getContainerInteractionRange() {
        return 3.0;
    }

    @Override
    public void shear(WorldServer var0, SoundCategory var1, ItemStack var2) {
        var0.playSound(null, this, SoundEffects.COPPER_GOLEM_SHEAR, var1, 1.0f, 1.0f);
        ItemStack var3 = this.getItemBySlot(EQUIPMENT_SLOT_ANTENNA);
        this.setItemSlot(EQUIPMENT_SLOT_ANTENNA, ItemStack.EMPTY);
        this.spawnAtLocation(var0, var3, 1.5f);
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && this.getItemBySlot(EQUIPMENT_SLOT_ANTENNA).is(TagsItem.SHEARABLE_FROM_COPPER_GOLEM);
    }

    @Override
    protected void dropEquipment(WorldServer var0) {
        super.dropEquipment(var0);
        this.dropPreservedEquipment(var0);
    }

    @Override
    protected void actuallyHurt(WorldServer var0, DamageSource var1, float var2) {
        super.actuallyHurt(var0, var1, var2);
        this.setState(CopperGolemState.IDLE);
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        super.thunderHit(var0, var1);
        UUID var2 = var1.getUUID();
        if (!var2.equals(this.lastLightningBoltUUID)) {
            this.lastLightningBoltUUID = var2;
            WeatheringCopper.a var3 = this.getWeatherState();
            if (var3 != WeatheringCopper.a.UNAFFECTED) {
                this.nextWeatheringTick = -1L;
                this.entityData.set(DATA_WEATHER_STATE, var3.previous(), true);
            }
        }
    }
}

