/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.fish;

import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.fish.EntityWaterAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;

public abstract class EntityFish
extends EntityWaterAnimal
implements Bucketable {
    private static final DataWatcherObject<Boolean> FROM_BUCKET = DataWatcher.defineId(EntityFish.class, DataWatcherRegistry.BOOLEAN);
    private static final boolean DEFAULT_FROM_BUCKET = false;

    public EntityFish(EntityTypes<? extends EntityFish> var0, World var1) {
        super((EntityTypes<? extends EntityWaterAnimal>)var0, var1);
        this.moveControl = new a(this);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 3.0);
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(FROM_BUCKET, false);
    }

    @Override
    public boolean fromBucket() {
        return this.entityData.get(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean var0) {
        this.entityData.set(FROM_BUCKET, var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("FromBucket", this.fromBucket());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setFromBucket(var0.getBooleanOr("FromBucket", false));
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.addGoal(2, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 8.0f, 1.6, 1.4, IEntitySelector.NO_SPECTATORS));
        this.goalSelector.addGoal(4, new b(this));
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationGuardian(this, var0);
    }

    @Override
    protected void travelInWater(Vec3D var0, double var1, boolean var3, double var4) {
        this.moveRelative(0.01f, var0);
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        if (this.getTarget() == null) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
        }
    }

    @Override
    public void aiStep() {
        if (!this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f, 0.4f, (this.random.nextFloat() * 2.0f - 1.0f) * 0.05f));
            this.setOnGround(false);
            this.needsSync = true;
            this.makeSound(this.getFlopSound());
        }
        super.aiStep();
    }

    @Override
    protected EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        return Bucketable.bucketMobPickup(var0, var1, this).orElse(super.mobInteract(var0, var1));
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        Bucketable.saveDefaultDataToBucketTag(this, var0);
    }

    @Override
    public void loadFromBucketTag(NBTTagCompound var0) {
        Bucketable.loadDefaultDataFromBucketTag(this, var0);
    }

    @Override
    public SoundEffect getPickupSound() {
        return SoundEffects.BUCKET_FILL_FISH;
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected abstract SoundEffect getFlopSound();

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.FISH_SWIM;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
    }

    static class a
    extends ControllerMove {
        private final EntityFish fish;

        a(EntityFish var0) {
            super(var0);
            this.fish = var0;
        }

        @Override
        public void tick() {
            if (this.fish.isEyeInFluid(TagsFluid.WATER)) {
                this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, 0.005, 0.0));
            }
            if (this.operation != ControllerMove.Operation.MOVE_TO || this.fish.getNavigation().isDone()) {
                this.fish.setSpeed(0.0f);
                return;
            }
            float var0 = (float)(this.speedModifier * this.fish.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
            this.fish.setSpeed(MathHelper.lerp(0.125f, this.fish.getSpeed(), var0));
            double var1 = this.wantedX - this.fish.getX();
            double var3 = this.wantedY - this.fish.getY();
            double var5 = this.wantedZ - this.fish.getZ();
            if (var3 != 0.0) {
                double var7 = Math.sqrt(var1 * var1 + var3 * var3 + var5 * var5);
                this.fish.setDeltaMovement(this.fish.getDeltaMovement().add(0.0, (double)this.fish.getSpeed() * (var3 / var7) * 0.1, 0.0));
            }
            if (var1 != 0.0 || var5 != 0.0) {
                float var7 = (float)(MathHelper.atan2(var5, var1) * 57.2957763671875) - 90.0f;
                this.fish.setYRot(this.rotlerp(this.fish.getYRot(), var7, 90.0f));
                this.fish.yBodyRot = this.fish.getYRot();
            }
        }
    }

    static class b
    extends PathfinderGoalRandomSwim {
        private final EntityFish fish;

        public b(EntityFish var0) {
            super(var0, 1.0, 40);
            this.fish = var0;
        }

        @Override
        public boolean canUse() {
            return this.fish.canRandomSwim() && super.canUse();
        }
    }
}

