/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.equine;

import java.util.function.DoubleSupplier;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityHorseZombie
extends EntityHorseAbstract {
    private static final float SPEED_FACTOR = 42.16f;
    private static final double BASE_JUMP_STRENGTH = 0.5;
    private static final double PER_RANDOM_JUMP_STRENGTH = 0.06666666666666667;
    private static final double BASE_SPEED = 9.0;
    private static final double PER_RANDOM_SPEED = 1.0;
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ZOMBIE_HORSE.getDimensions().withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, 0.0f, EntityTypes.ZOMBIE_HORSE.getHeight() - 0.03125f, 0.0f)).scale(0.5f);

    public EntityHorseZombie(EntityTypes<? extends EntityHorseZombie> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
        this.setPathfindingMalus(PathType.DANGER_OTHER, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, -1.0f);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityHorseZombie.createBaseHorseAttributes().add(GenericAttributes.MAX_HEALTH, 25.0);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        this.setPersistenceRequired();
        return super.interact(var0, var1);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return true;
    }

    @Override
    public boolean isMobControlled() {
        return this.getFirstPassenger() instanceof EntityInsentient;
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(EntityHorseZombie.generateZombieHorseJumpStrength(var0::nextDouble));
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(EntityHorseZombie.generateZombieHorseSpeed(var0::nextDouble));
    }

    private static double generateZombieHorseJumpStrength(DoubleSupplier var0) {
        return 0.5 + var0.getAsDouble() * 0.06666666666666667 + var0.getAsDouble() * 0.06666666666666667 + var0.getAsDouble() * 0.06666666666666667;
    }

    private static double generateZombieHorseSpeed(DoubleSupplier var0) {
        return (9.0 + var0.getAsDouble() * 1.0 + var0.getAsDouble() * 1.0 + var0.getAsDouble() * 1.0) / (double)42.16f;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.ZOMBIE_HORSE_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.ZOMBIE_HORSE_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ZOMBIE_HORSE_HURT;
    }

    @Override
    protected SoundEffect getAngrySound() {
        return SoundEffects.ZOMBIE_HORSE_ANGRY;
    }

    @Override
    protected SoundEffect getEatingSound() {
        return SoundEffects.ZOMBIE_HORSE_EAT;
    }

    @Override
    public @Nullable EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return null;
    }

    @Override
    public boolean canFallInLove() {
        return false;
    }

    @Override
    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.25, var0 -> var0.is(TagsItem.ZOMBIE_HORSE_FOOD), false));
    }

    @Override
    public @Nullable GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        EntityZombie var4;
        if (var2 == EntitySpawnReason.NATURAL && (var4 = EntityTypes.ZOMBIE.create(this.level(), EntitySpawnReason.JOCKEY)) != null) {
            var4.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
            var4.finalizeSpawn(var0, var1, var2, null);
            var4.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
            var4.startRiding(this, false, false);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return EnumInteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return true;
    }

    @Override
    public boolean canBeLeashed() {
        return this.isTamed() || !this.isMobControlled();
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.ZOMBIE_HORSE_FOOD);
    }

    @Override
    protected EnumItemSlot sunProtectionSlot() {
        return EnumItemSlot.BODY;
    }

    @Override
    public Vec3D[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets(this, 0.04, 0.41, 0.18, 0.73);
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(var0);
    }

    @Override
    public float chargeSpeedModifier() {
        return 1.4f;
    }
}

