/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.BinaryAnimator;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.EasingType;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class Axolotl
extends EntityAnimal
implements Bucketable {
    public static final int TOTAL_PLAYDEAD_TIME = 200;
    private static final int POSE_ANIMATION_TICKS = 10;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_ADULT, SensorType.HURT_BY, SensorType.AXOLOTL_ATTACKABLES, SensorType.FOOD_TEMPTATIONS);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.PLAY_DEAD_TICKS, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.IS_PANICKING});
    private static final DataWatcherObject<Integer> DATA_VARIANT = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_PLAYING_DEAD = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> FROM_BUCKET = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.BOOLEAN);
    public static final double PLAYER_REGEN_DETECTION_RANGE = 20.0;
    public static final int RARE_VARIANT_CHANCE = 1200;
    private static final int AXOLOTL_TOTAL_AIR_SUPPLY = 6000;
    public static final String VARIANT_TAG = "Variant";
    private static final int REHYDRATE_AIR_SUPPLY = 1800;
    private static final int REGEN_BUFF_MAX_DURATION = 2400;
    private static final boolean DEFAULT_FROM_BUCKET = false;
    public final BinaryAnimator playingDeadAnimator = new BinaryAnimator(10, EasingType.IN_OUT_SINE);
    public final BinaryAnimator inWaterAnimator = new BinaryAnimator(10, EasingType.IN_OUT_SINE);
    public final BinaryAnimator onGroundAnimator = new BinaryAnimator(10, EasingType.IN_OUT_SINE);
    public final BinaryAnimator movingAnimator = new BinaryAnimator(10, EasingType.IN_OUT_SINE);
    private static final int REGEN_BUFF_BASE_DURATION = 100;

    public Axolotl(EntityTypes<? extends Axolotl> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new d(this);
        this.lookControl = new c(this, 20);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT, 0);
        var0.define(DATA_PLAYING_DEAD, false);
        var0.define(FROM_BUCKET, false);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.store(VARIANT_TAG, Variant.LEGACY_CODEC, this.getVariant());
        var0.putBoolean("FromBucket", this.fromBucket());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(var0.read(VARIANT_TAG, Variant.LEGACY_CODEC).orElse(Variant.DEFAULT));
        this.setFromBucket(var0.getBooleanOr("FromBucket", false));
    }

    @Override
    public void playAmbientSound() {
        if (this.isPlayingDead()) {
            return;
        }
        super.playAmbientSound();
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        boolean var4 = false;
        if (var2 == EntitySpawnReason.BUCKET) {
            return var3;
        }
        RandomSource var5 = var0.getRandom();
        if (var3 instanceof b) {
            if (((b)var3).getGroupSize() >= 2) {
                var4 = true;
            }
        } else {
            var3 = new b(Variant.getCommonSpawnVariant(var5), Variant.getCommonSpawnVariant(var5));
        }
        this.setVariant(((b)var3).getVariant(var5));
        if (var4) {
            this.setAge(-24000);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public void baseTick() {
        World world;
        int var0 = this.getAirSupply();
        super.baseTick();
        if (!this.isNoAi() && (world = this.level()) instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.handleAirSupply(var1, var0);
        }
        if (this.level().isClientSide()) {
            this.tickAnimations();
        }
    }

    private void tickAnimations() {
        a var0 = this.isPlayingDead() ? a.PLAYING_DEAD : (this.isInWater() ? a.IN_WATER : (this.onGround() ? a.ON_GROUND : a.IN_AIR));
        this.playingDeadAnimator.tick(var0 == a.PLAYING_DEAD);
        this.inWaterAnimator.tick(var0 == a.IN_WATER);
        this.onGroundAnimator.tick(var0 == a.ON_GROUND);
        boolean var1 = this.walkAnimation.isMoving() || this.getXRot() != this.xRotO || this.getYRot() != this.yRotO;
        this.movingAnimator.tick(var1);
    }

    protected void handleAirSupply(WorldServer var0, int var1) {
        if (this.isAlive() && !this.isInWaterOrRain()) {
            this.setAirSupply(var1 - 1);
            if (this.shouldTakeDrowningDamage()) {
                this.setAirSupply(0);
                this.hurtServer(var0, this.damageSources().dryOut(), 2.0f);
            }
        } else {
            this.setAirSupply(this.getMaxAirSupply());
        }
    }

    public void rehydrate() {
        int var0 = this.getAirSupply() + 1800;
        this.setAirSupply(Math.min(var0, this.getMaxAirSupply()));
    }

    @Override
    public int getMaxAirSupply() {
        return 6000;
    }

    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_VARIANT));
    }

    public void setVariant(Variant var0) {
        this.entityData.set(DATA_VARIANT, var0.getId());
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> var0) {
        if (var0 == DataComponents.AXOLOTL_VARIANT) {
            return Axolotl.castComponentValue(var0, this.getVariant());
        }
        return super.get(var0);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        this.applyImplicitComponentIfPresent(var0, DataComponents.AXOLOTL_VARIANT);
        super.applyImplicitComponents(var0);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> var0, T var1) {
        if (var0 == DataComponents.AXOLOTL_VARIANT) {
            this.setVariant(Axolotl.castComponentValue(DataComponents.AXOLOTL_VARIANT, var1));
            return true;
        }
        return super.applyImplicitComponent(var0, var1);
    }

    private static boolean useRareVariant(RandomSource var0) {
        return var0.nextInt(1200) == 0;
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    public void setPlayingDead(boolean var0) {
        this.entityData.set(DATA_PLAYING_DEAD, var0);
    }

    public boolean isPlayingDead() {
        return this.entityData.get(DATA_PLAYING_DEAD);
    }

    @Override
    public boolean fromBucket() {
        return this.entityData.get(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean var0) {
        this.entityData.set(FROM_BUCKET, var0);
    }

    @Override
    public @Nullable EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        Axolotl var2 = EntityTypes.AXOLOTL.create(var0, EntitySpawnReason.BREEDING);
        if (var2 != null) {
            Variant var3 = Axolotl.useRareVariant(this.random) ? Variant.getRareSpawnVariant(this.random) : (this.random.nextBoolean() ? this.getVariant() : ((Axolotl)var1).getVariant());
            var2.setVariant(var3);
            var2.setPersistenceRequired();
        }
        return var2;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.AXOLOTL_FOOD);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected void customServerAiStep(WorldServer var0) {
        GameProfilerFiller var1 = Profiler.get();
        var1.push("axolotlBrain");
        this.getBrain().tick(var0, this);
        var1.pop();
        var1.push("axolotlActivityUpdate");
        AxolotlAi.updateActivity(this);
        var1.pop();
        if (!this.isNoAi()) {
            Optional<Integer> var2 = this.getBrain().getMemory(MemoryModuleType.PLAY_DEAD_TICKS);
            this.setPlayingDead(var2.isPresent() && var2.get() > 0);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityAnimal.createAnimalAttributes().add(GenericAttributes.MAX_HEALTH, 14.0).add(GenericAttributes.MOVEMENT_SPEED, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new AmphibiousPathNavigation(this, var0);
    }

    @Override
    public void playAttackSound() {
        this.playSound(SoundEffects.AXOLOTL_ATTACK, 1.0f, 1.0f);
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        float var3 = this.getHealth();
        if (!this.isNoAi() && this.level().random.nextInt(3) == 0 && ((float)this.level().random.nextInt(3) < var2 || var3 / this.getMaxHealth() < 0.5f) && var2 < var3 && this.isInWater() && (var1.getEntity() != null || var1.getDirectEntity() != null) && !this.isPlayingDead()) {
            this.brain.setMemory(MemoryModuleType.PLAY_DEAD_TICKS, 200);
        }
        return super.hurtServer(var0, var1, var2);
    }

    @Override
    public int getMaxHeadXRot() {
        return 1;
    }

    @Override
    public int getMaxHeadYRot() {
        return 1;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        return Bucketable.bucketMobPickup(var0, var1, this).orElse(super.mobInteract(var0, var1));
    }

    @Override
    public void saveToBucketTag(ItemStack var02) {
        Bucketable.saveDefaultDataToBucketTag(this, var02);
        var02.copyFrom(DataComponents.AXOLOTL_VARIANT, this);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, var02, var0 -> {
            var0.putInt("Age", this.getAge());
            BehaviorController<Axolotl> var1 = this.getBrain();
            if (var1.hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN)) {
                var0.putLong("HuntingCooldown", var1.getTimeUntilExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN));
            }
        });
    }

    @Override
    public void loadFromBucketTag(NBTTagCompound var0) {
        Bucketable.loadDefaultDataFromBucketTag(this, var0);
        this.setAge(var0.getIntOr("Age", 0));
        var0.getLong("HuntingCooldown").ifPresentOrElse(var1 -> this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, true, var0.getLongOr("HuntingCooldown", 0L)), () -> this.getBrain().setMemory(MemoryModuleType.HAS_HUNTING_COOLDOWN, Optional.empty()));
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.AXOLOTL_BUCKET);
    }

    @Override
    public SoundEffect getPickupSound() {
        return SoundEffects.BUCKET_FILL_AXOLOTL;
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.isPlayingDead() && super.canBeSeenAsEnemy();
    }

    public static void onStopAttacking(WorldServer var0, Axolotl var1, EntityLiving var2) {
        Entity var4;
        DamageSource var3;
        if (var2.isDeadOrDying() && (var3 = var2.getLastDamageSource()) != null && (var4 = var3.getEntity()) != null && var4.getType() == EntityTypes.PLAYER) {
            EntityHuman var5 = (EntityHuman)var4;
            List<EntityHuman> var6 = var0.getEntitiesOfClass(EntityHuman.class, var1.getBoundingBox().inflate(20.0));
            if (var6.contains(var5)) {
                var1.applySupportingEffects(var5);
            }
        }
    }

    public void applySupportingEffects(EntityHuman var0) {
        MobEffect var1 = var0.getEffect(MobEffects.REGENERATION);
        if (var1 == null || var1.endsWithin(2399)) {
            int var2 = var1 != null ? var1.getDuration() : 0;
            int var3 = Math.min(2400, 100 + var2);
            var0.addEffect(new MobEffect(MobEffects.REGENERATION, var3, 0), this);
        }
        var0.removeEffect(MobEffects.MINING_FATIGUE);
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.AXOLOTL_HURT;
    }

    @Override
    protected @Nullable SoundEffect getDeathSound() {
        return SoundEffects.AXOLOTL_DEATH;
    }

    @Override
    protected @Nullable SoundEffect getAmbientSound() {
        return this.isInWater() ? SoundEffects.AXOLOTL_IDLE_WATER : SoundEffects.AXOLOTL_IDLE_AIR;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.AXOLOTL_SPLASH;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.AXOLOTL_SWIM;
    }

    protected BehaviorController.b<Axolotl> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return AxolotlAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Axolotl> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void travelInWater(Vec3D var0, double var1, boolean var3, double var4) {
        this.moveRelative(this.getSpeed(), var0);
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    @Override
    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (var2.is(Items.TROPICAL_FISH_BUCKET)) {
            var0.setItemInHand(var1, ItemLiquidUtil.createFilledResult(var2, var0, new ItemStack(Items.WATER_BUCKET)));
        } else {
            super.usePlayerItem(var0, var1, var2);
        }
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    @Override
    public @Nullable EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }

    public static boolean checkAxolotlSpawnRules(EntityTypes<? extends EntityLiving> var0, WorldAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.AXOLOTLS_SPAWNABLE_ON);
    }

    static class d
    extends SmoothSwimmingMoveControl {
        private final Axolotl axolotl;

        public d(Axolotl var0) {
            super(var0, 85, 10, 0.1f, 0.5f, false);
            this.axolotl = var0;
        }

        @Override
        public void tick() {
            if (!this.axolotl.isPlayingDead()) {
                super.tick();
            }
        }
    }

    class c
    extends SmoothSwimmingLookControl {
        public c(Axolotl var1, int var2) {
            super(var1, var2);
        }

        @Override
        public void tick() {
            if (!Axolotl.this.isPlayingDead()) {
                super.tick();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant LUCY = new Variant(0, "lucy", true);
        public static final /* enum */ Variant WILD = new Variant(1, "wild", true);
        public static final /* enum */ Variant GOLD = new Variant(2, "gold", true);
        public static final /* enum */ Variant CYAN = new Variant(3, "cyan", true);
        public static final /* enum */ Variant BLUE = new Variant(4, "blue", false);
        public static final Variant DEFAULT;
        private static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        public static final Codec<Variant> CODEC;
        @Deprecated
        public static final Codec<Variant> LEGACY_CODEC;
        private final int id;
        private final String name;
        private final boolean common;
        private static final /* synthetic */ Variant[] n;

        public static Variant[] values() {
            return (Variant[])n.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(int var2, String var3, boolean var4) {
            this.id = var2;
            this.name = var3;
            this.common = var4;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int var0) {
            return BY_ID.apply(var0);
        }

        public static Variant getCommonSpawnVariant(RandomSource var0) {
            return Variant.getSpawnVariant(var0, true);
        }

        public static Variant getRareSpawnVariant(RandomSource var0) {
            return Variant.getSpawnVariant(var0, false);
        }

        private static Variant getSpawnVariant(RandomSource var0, boolean var12) {
            Variant[] var2 = (Variant[])Arrays.stream(Variant.values()).filter(var1 -> var1.common == var12).toArray(Variant[]::new);
            return SystemUtils.getRandom(var2, var0);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{LUCY, WILD, GOLD, CYAN, BLUE};
        }

        static {
            n = Variant.d();
            DEFAULT = LUCY;
            BY_ID = ByIdMap.continuous(Variant::getId, Variant.values(), ByIdMap.a.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::getId);
            CODEC = INamable.fromEnum(Variant::values);
            LEGACY_CODEC = Codec.INT.xmap(BY_ID::apply, Variant::getId);
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Variant[] types;

        public b(Variant ... var0) {
            super(false);
            this.types = var0;
        }

        public Variant getVariant(RandomSource var0) {
            return this.types[var0.nextInt(this.types.length)];
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a PLAYING_DEAD = new a();
        public static final /* enum */ a IN_WATER = new a();
        public static final /* enum */ a ON_GROUND = new a();
        public static final /* enum */ a IN_AIR = new a();
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{PLAYING_DEAD, IN_WATER, ON_GROUND, IN_AIR};
        }

        static {
            e = a.a();
        }
    }
}

