/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class RandomPositionGenerator {
    private static final int RANDOM_POS_ATTEMPTS = 10;

    public static BlockPosition generateRandomDirection(RandomSource var0, int var1, int var2) {
        int var3 = var0.nextInt(2 * var1 + 1) - var1;
        int var4 = var0.nextInt(2 * var2 + 1) - var2;
        int var5 = var0.nextInt(2 * var1 + 1) - var1;
        return new BlockPosition(var3, var4, var5);
    }

    public static @Nullable BlockPosition generateRandomDirectionWithinRadians(RandomSource var0, double var1, double var3, int var5, int var6, double var7, double var9, double var11) {
        double var13 = MathHelper.atan2(var9, var7) - 1.5707963705062866;
        double var15 = var13 + (double)(2.0f * var0.nextFloat() - 1.0f) * var11;
        double var17 = MathHelper.lerp(Math.sqrt(var0.nextDouble()), var1, var3) * (double)MathHelper.SQRT_OF_TWO;
        double var19 = -var17 * Math.sin(var15);
        double var21 = var17 * Math.cos(var15);
        if (Math.abs(var19) > var3 || Math.abs(var21) > var3) {
            return null;
        }
        int var23 = var0.nextInt(2 * var5 + 1) - var5 + var6;
        return BlockPosition.containing(var19, var23, var21);
    }

    @VisibleForTesting
    public static BlockPosition moveUpOutOfSolid(BlockPosition var0, int var1, Predicate<BlockPosition> var2) {
        if (var2.test(var0)) {
            BlockPosition.MutableBlockPosition var3 = var0.mutable().move(EnumDirection.UP);
            while (var3.getY() <= var1 && var2.test(var3)) {
                var3.move(EnumDirection.UP);
            }
            return var3.immutable();
        }
        return var0;
    }

    @VisibleForTesting
    public static BlockPosition moveUpToAboveSolid(BlockPosition var0, int var1, int var2, Predicate<BlockPosition> var3) {
        if (var1 < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + var1 + ", expected >= 0");
        }
        if (var3.test(var0)) {
            BlockPosition.MutableBlockPosition var4 = var0.mutable().move(EnumDirection.UP);
            while (var4.getY() <= var2 && var3.test(var4)) {
                var4.move(EnumDirection.UP);
            }
            int var5 = var4.getY();
            while (var4.getY() <= var2 && var4.getY() - var5 < var1) {
                var4.move(EnumDirection.UP);
                if (!var3.test(var4)) continue;
                var4.move(EnumDirection.DOWN);
                break;
            }
            return var4.immutable();
        }
        return var0;
    }

    public static @Nullable Vec3D generateRandomPos(EntityCreature var0, Supplier<@Nullable BlockPosition> var1) {
        return RandomPositionGenerator.generateRandomPos(var1, var0::getWalkTargetValue);
    }

    public static @Nullable Vec3D generateRandomPos(Supplier<@Nullable BlockPosition> var0, ToDoubleFunction<BlockPosition> var1) {
        double var2 = Double.NEGATIVE_INFINITY;
        BlockPosition var4 = null;
        for (int var5 = 0; var5 < 10; ++var5) {
            double var7;
            BlockPosition var6 = var0.get();
            if (var6 == null || !((var7 = var1.applyAsDouble(var6)) > var2)) continue;
            var2 = var7;
            var4 = var6;
        }
        return var4 != null ? Vec3D.atBottomCenterOf(var4) : null;
    }

    public static BlockPosition generateRandomPosTowardDirection(EntityCreature var0, double var1, RandomSource var3, BlockPosition var4) {
        double var5 = var4.getX();
        double var7 = var4.getZ();
        if (var0.hasHome() && var1 > 1.0) {
            BlockPosition var9 = var0.getHomePosition();
            var5 = var0.getX() > (double)var9.getX() ? (var5 -= var3.nextDouble() * var1 / 2.0) : (var5 += var3.nextDouble() * var1 / 2.0);
            var7 = var0.getZ() > (double)var9.getZ() ? (var7 -= var3.nextDouble() * var1 / 2.0) : (var7 += var3.nextDouble() * var1 / 2.0);
        }
        return BlockPosition.containing(var5 + var0.getX(), (double)var4.getY() + var0.getY(), var7 + var0.getZ());
    }
}

