/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.util.RandomPositionGenerator;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class LandRandomPos {
    public static @Nullable Vec3D getPos(EntityCreature var0, int var1, int var2) {
        return LandRandomPos.getPos(var0, var1, var2, var0::getWalkTargetValue);
    }

    public static @Nullable Vec3D getPos(EntityCreature var0, int var1, int var2, ToDoubleFunction<BlockPosition> var3) {
        boolean var4 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return RandomPositionGenerator.generateRandomPos(() -> {
            BlockPosition var4 = RandomPositionGenerator.generateRandomDirection(var0.getRandom(), var1, var2);
            BlockPosition var5 = LandRandomPos.generateRandomPosTowardDirection(var0, var1, var4, var4);
            if (var5 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var5);
        }, var3);
    }

    public static @Nullable Vec3D getPosTowards(EntityCreature var0, int var1, int var2, Vec3D var3) {
        Vec3D var4 = var3.subtract(var0.getX(), var0.getY(), var0.getZ());
        boolean var5 = PathfinderGoalUtil.mobRestricted(var0, var1);
        return LandRandomPos.getPosInDirection(var0, 0.0, var1, var2, var4, var5);
    }

    public static @Nullable Vec3D getPosAway(EntityCreature var0, int var1, int var2, Vec3D var3) {
        return LandRandomPos.getPosAway(var0, 0.0, var1, var2, var3);
    }

    public static @Nullable Vec3D getPosAway(EntityCreature var0, double var1, double var3, int var5, Vec3D var6) {
        Vec3D var7 = var0.position().subtract(var6);
        if (var7.length() == 0.0) {
            var7 = new Vec3D(var0.getRandom().nextDouble() - 0.5, 0.0, var0.getRandom().nextDouble() - 0.5);
        }
        boolean var8 = PathfinderGoalUtil.mobRestricted(var0, var3);
        return LandRandomPos.getPosInDirection(var0, var1, var3, var5, var7, var8);
    }

    private static @Nullable Vec3D getPosInDirection(EntityCreature var0, double var1, double var3, int var5, Vec3D var6, boolean var7) {
        return RandomPositionGenerator.generateRandomPos(var0, () -> {
            BlockPosition var8 = RandomPositionGenerator.generateRandomDirectionWithinRadians(var0.getRandom(), var1, var3, var5, 0, var6.x, var6.z, 1.5707963705062866);
            if (var8 == null) {
                return null;
            }
            BlockPosition var9 = LandRandomPos.generateRandomPosTowardDirection(var0, var3, var7, var8);
            if (var9 == null) {
                return null;
            }
            return LandRandomPos.movePosUpOutOfSolid(var0, var9);
        });
    }

    public static @Nullable BlockPosition movePosUpOutOfSolid(EntityCreature var0, BlockPosition var12) {
        if (PathfinderGoalUtil.isWater(var0, var12 = RandomPositionGenerator.moveUpOutOfSolid(var12, var0.level().getMaxY(), var1 -> PathfinderGoalUtil.isSolid(var0, var1))) || PathfinderGoalUtil.hasMalus(var0, var12)) {
            return null;
        }
        return var12;
    }

    public static @Nullable BlockPosition generateRandomPosTowardDirection(EntityCreature var0, double var1, boolean var3, BlockPosition var4) {
        BlockPosition var5 = RandomPositionGenerator.generateRandomPosTowardDirection(var0, var1, var0.getRandom(), var4);
        if (PathfinderGoalUtil.isOutsideLimits(var5, var0) || PathfinderGoalUtil.isRestricted(var3, var0, var5) || PathfinderGoalUtil.isNotStable(var0.getNavigation(), var5)) {
            return null;
        }
        return var5;
    }
}

