/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class TemptingSensor
extends Sensor<EntityCreature> {
    private static final PathfinderTargetCondition TEMPT_TARGETING = PathfinderTargetCondition.forNonCombat().ignoreLineOfSight();
    private final BiPredicate<EntityCreature, ItemStack> temptations;

    public TemptingSensor(Predicate<ItemStack> var0) {
        this((EntityCreature var1, ItemStack var2) -> var0.test((ItemStack)var2));
    }

    public static TemptingSensor forAnimal() {
        return new TemptingSensor((var0, var1) -> {
            if (var0 instanceof EntityAnimal) {
                EntityAnimal var2 = (EntityAnimal)var0;
                return var2.isFood((ItemStack)var1);
            }
            return false;
        });
    }

    private TemptingSensor(BiPredicate<EntityCreature, ItemStack> var0) {
        this.temptations = var0;
    }

    @Override
    protected void doTick(WorldServer var0, EntityCreature var12) {
        BehaviorController<?> var2 = var12.getBrain();
        PathfinderTargetCondition var32 = TEMPT_TARGETING.copy().range((float)var12.getAttributeValue(GenericAttributes.TEMPT_RANGE));
        List var4 = var0.players().stream().filter(IEntitySelector.NO_SPECTATORS).filter(var3 -> var32.test(var0, var12, (EntityLiving)var3)).filter(var1 -> this.playerHoldingTemptation(var12, (EntityHuman)var1)).filter(var1 -> !var12.hasPassenger((Entity)var1)).sorted(Comparator.comparingDouble(var12::distanceToSqr)).collect(Collectors.toList());
        if (!var4.isEmpty()) {
            EntityHuman var5 = (EntityHuman)var4.get(0);
            var2.setMemory(MemoryModuleType.TEMPTING_PLAYER, var5);
        } else {
            var2.eraseMemory(MemoryModuleType.TEMPTING_PLAYER);
        }
    }

    private boolean playerHoldingTemptation(EntityCreature var0, EntityHuman var1) {
        return this.isTemptation(var0, var1.getMainHandItem()) || this.isTemptation(var0, var1.getOffhandItem());
    }

    private boolean isTemptation(EntityCreature var0, ItemStack var1) {
        return this.temptations.test(var0, var1);
    }

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.TEMPTING_PLAYER);
    }
}

