/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalTempt
extends PathfinderGoal {
    private static final PathfinderTargetCondition TEMPT_TARGETING = PathfinderTargetCondition.forNonCombat().ignoreLineOfSight();
    private static final double DEFAULT_STOP_DISTANCE = 2.5;
    private final PathfinderTargetCondition targetingConditions;
    protected final EntityInsentient mob;
    protected final double speedModifier;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    protected @Nullable EntityHuman player;
    private int calmDown;
    private boolean isRunning;
    private final Predicate<ItemStack> items;
    private final boolean canScare;
    private final double stopDistance;

    public PathfinderGoalTempt(EntityCreature var0, double var1, Predicate<ItemStack> var3, boolean var4) {
        this((EntityInsentient)var0, var1, var3, var4, 2.5);
    }

    public PathfinderGoalTempt(EntityCreature var0, double var1, Predicate<ItemStack> var3, boolean var4, double var5) {
        this((EntityInsentient)var0, var1, var3, var4, var5);
    }

    PathfinderGoalTempt(EntityInsentient var02, double var12, Predicate<ItemStack> var3, boolean var4, double var5) {
        this.mob = var02;
        this.speedModifier = var12;
        this.items = var3;
        this.canScare = var4;
        this.stopDistance = var5;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        this.targetingConditions = TEMPT_TARGETING.copy().selector((var0, var1) -> this.shouldFollow(var0));
    }

    @Override
    public boolean canUse() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = PathfinderGoalTempt.getServerLevel(this.mob).getNearestPlayer(this.targetingConditions.range(this.mob.getAttributeValue(GenericAttributes.TEMPT_RANGE)), this.mob);
        return this.player != null;
    }

    private boolean shouldFollow(EntityLiving var0) {
        return this.items.test(var0.getMainHandItem()) || this.items.test(var0.getOffhandItem());
    }

    @Override
    public boolean canContinueToUse() {
        if (this.canScare()) {
            if (this.mob.distanceToSqr(this.player) < 36.0) {
                if (this.player.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.player.getYRot() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.getX();
                this.py = this.player.getY();
                this.pz = this.player.getZ();
            }
            this.pRotX = this.player.getXRot();
            this.pRotY = this.player.getYRot();
        }
        return this.canUse();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    @Override
    public void start() {
        this.px = this.player.getX();
        this.py = this.player.getY();
        this.pz = this.player.getZ();
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.player = null;
        this.stopNavigation();
        this.calmDown = PathfinderGoalTempt.reducedTickDelay(100);
        this.isRunning = false;
    }

    @Override
    public void tick() {
        this.mob.getLookControl().setLookAt(this.player, this.mob.getMaxHeadYRot() + 20, this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr(this.player) < this.stopDistance * this.stopDistance) {
            this.stopNavigation();
        } else {
            this.navigateTowards(this.player);
        }
    }

    protected void stopNavigation() {
        this.mob.getNavigation().stop();
    }

    protected void navigateTowards(EntityHuman var0) {
        this.mob.getNavigation().moveTo(var0, this.speedModifier);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public static class a
    extends PathfinderGoalTempt {
        public a(EntityInsentient var0, double var1, Predicate<ItemStack> var3, boolean var4, double var5) {
            super(var0, var1, var3, var4, var5);
        }

        @Override
        protected void stopNavigation() {
            this.mob.getMoveControl().setWait();
        }

        @Override
        protected void navigateTowards(EntityHuman var0) {
            Vec3D var1 = var0.getEyePosition().subtract(this.mob.position()).scale(this.mob.getRandom().nextDouble()).add(this.mob.position());
            this.mob.getMoveControl().setWantedPosition(var1.x, var1.y, var1.z, this.speedModifier);
        }
    }
}

