/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalPanic
extends PathfinderGoal {
    public static final int WATER_CHECK_DISTANCE_VERTICAL = 1;
    protected final EntityCreature mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;
    private final Function<EntityCreature, TagKey<DamageType>> panicCausingDamageTypes;

    public PathfinderGoalPanic(EntityCreature var0, double var1) {
        this(var0, var1, DamageTypeTags.PANIC_CAUSES);
    }

    public PathfinderGoalPanic(EntityCreature var0, double var12, TagKey<DamageType> var3) {
        this(var0, var12, (EntityCreature var1) -> var3);
    }

    public PathfinderGoalPanic(EntityCreature var0, double var1, Function<EntityCreature, TagKey<DamageType>> var3) {
        this.mob = var0;
        this.speedModifier = var1;
        this.panicCausingDamageTypes = var3;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
    }

    @Override
    public boolean canUse() {
        BlockPosition var0;
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.isOnFire() && (var0 = this.lookForWater(this.mob.level(), this.mob, 5)) != null) {
            this.posX = var0.getX();
            this.posY = var0.getY();
            this.posZ = var0.getZ();
            return true;
        }
        return this.findRandomPosition();
    }

    protected boolean shouldPanic() {
        return this.mob.getLastDamageSource() != null && this.mob.getLastDamageSource().is(this.panicCausingDamageTypes.apply(this.mob));
    }

    protected boolean findRandomPosition() {
        Vec3D var0 = DefaultRandomPos.getPos(this.mob, 5, 4);
        if (var0 == null) {
            return false;
        }
        this.posX = var0.x;
        this.posY = var0.y;
        this.posZ = var0.z;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void start() {
        this.mob.getNavigation().moveTo(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.mob.getNavigation().isDone();
    }

    protected @Nullable BlockPosition lookForWater(IBlockAccess var0, Entity var12, int var2) {
        BlockPosition var3 = var12.blockPosition();
        if (!var0.getBlockState(var3).getCollisionShape(var0, var3).isEmpty()) {
            return null;
        }
        return BlockPosition.findClosestMatch(var12.blockPosition(), var2, 1, var1 -> var0.getFluidState((BlockPosition)var1).is(TagsFluid.WATER)).orElse(null);
    }
}

