/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AxisAlignedBB;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalOfferFlower
extends PathfinderGoal {
    private static final PathfinderTargetCondition OFFER_TARGET_CONTEXT = PathfinderTargetCondition.forNonCombat().range(6.0);
    private static final Item OFFER_ITEM = Items.POPPY;
    public static final int OFFER_TICKS = 400;
    private final EntityIronGolem golem;
    private @Nullable EntityLiving entity;
    private int tick;

    public PathfinderGoalOfferFlower(EntityIronGolem var0) {
        this.golem = var0;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
    }

    @Override
    public boolean canUse() {
        if (!this.golem.level().isBrightOutside()) {
            return false;
        }
        if (this.golem.getRandom().nextInt(8000) != 0) {
            return false;
        }
        this.entity = PathfinderGoalOfferFlower.getServerLevel(this.golem).getNearestEntity(TagsEntity.CANDIDATE_FOR_IRON_GOLEM_GIFT, OFFER_TARGET_CONTEXT, (EntityLiving)this.golem, this.golem.getX(), this.golem.getY(), this.golem.getZ(), this.getGolemBoundingBox());
        return this.entity != null;
    }

    @Override
    public boolean canContinueToUse() {
        return this.tick > 0;
    }

    @Override
    public void start() {
        this.tick = this.adjustedTickDelay(400);
        this.golem.offerFlower(true);
    }

    @Override
    public void stop() {
        EntityInsentient var0;
        EntityLiving entityLiving;
        this.golem.offerFlower(false);
        if (this.tick == 0 && (entityLiving = this.entity) instanceof EntityInsentient && (var0 = (EntityInsentient)entityLiving).getType().is(TagsEntity.ACCEPTS_IRON_GOLEM_GIFT) && var0.getItemBySlot(CopperGolem.EQUIPMENT_SLOT_ANTENNA).isEmpty() && this.getGolemBoundingBox().intersects(var0.getBoundingBox())) {
            var0.setItemSlot(CopperGolem.EQUIPMENT_SLOT_ANTENNA, OFFER_ITEM.getDefaultInstance());
            var0.setGuaranteedDrop(CopperGolem.EQUIPMENT_SLOT_ANTENNA);
        }
        this.entity = null;
    }

    @Override
    public void tick() {
        if (this.entity != null) {
            this.golem.getLookControl().setLookAt(this.entity, 30.0f, 30.0f);
        }
        --this.tick;
    }

    private AxisAlignedBB getGolemBoundingBox() {
        return this.golem.getBoundingBox().inflate(6.0, 2.0, 6.0);
    }
}

