/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBoat;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalFollowBoat
extends PathfinderGoal {
    private int timeToRecalcPath;
    private final EntityCreature mob;
    private @Nullable EntityHuman following;
    private PathfinderGoalBoat currentGoal;

    public PathfinderGoalFollowBoat(EntityCreature var0) {
        this.mob = var0;
    }

    @Override
    public boolean canUse() {
        if (this.following != null && this.following.hasMovedHorizontallyRecently()) {
            return true;
        }
        List<AbstractBoat> var0 = this.mob.level().getEntitiesOfClass(AbstractBoat.class, this.mob.getBoundingBox().inflate(5.0));
        for (AbstractBoat var2 : var0) {
            EntityHuman var3;
            EntityLiving entityLiving = var2.getControllingPassenger();
            if (!(entityLiving instanceof EntityHuman) || !(var3 = (EntityHuman)entityLiving).hasMovedHorizontallyRecently()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInterruptable() {
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        return this.following != null && this.following.isPassenger() && this.following.hasMovedHorizontallyRecently();
    }

    @Override
    public void start() {
        List<AbstractBoat> var0 = this.mob.level().getEntitiesOfClass(AbstractBoat.class, this.mob.getBoundingBox().inflate(5.0));
        for (AbstractBoat var2 : var0) {
            EntityHuman var3;
            EntityLiving entityLiving = var2.getControllingPassenger();
            if (!(entityLiving instanceof EntityHuman)) continue;
            this.following = var3 = (EntityHuman)entityLiving;
            break;
        }
        this.timeToRecalcPath = 0;
        this.currentGoal = PathfinderGoalBoat.GO_TO_BOAT;
    }

    @Override
    public void stop() {
        this.following = null;
    }

    @Override
    public void tick() {
        float var0 = this.currentGoal == PathfinderGoalBoat.GO_IN_BOAT_DIRECTION ? 0.01f : 0.015f;
        this.mob.moveRelative(var0, new Vec3D(this.mob.xxa, this.mob.yya, this.mob.zza));
        this.mob.move(EnumMoveType.SELF, this.mob.getDeltaMovement());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        if (this.currentGoal == PathfinderGoalBoat.GO_TO_BOAT) {
            BlockPosition var1 = this.following.blockPosition().relative(this.following.getDirection().getOpposite());
            var1 = var1.offset(0, -1, 0);
            this.mob.getNavigation().moveTo(var1.getX(), var1.getY(), var1.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) < 4.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = PathfinderGoalBoat.GO_IN_BOAT_DIRECTION;
            }
        } else if (this.currentGoal == PathfinderGoalBoat.GO_IN_BOAT_DIRECTION) {
            EnumDirection var1 = this.following.getMotionDirection();
            BlockPosition var2 = this.following.blockPosition().relative(var1, 10);
            this.mob.getNavigation().moveTo(var2.getX(), var2.getY() - 1, var2.getZ(), 1.0);
            if (this.mob.distanceTo(this.following) > 12.0f) {
                this.timeToRecalcPath = 0;
                this.currentGoal = PathfinderGoalBoat.GO_TO_BOAT;
            }
        }
    }
}

