/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class PathfinderGoalAvoidTarget<T extends EntityLiving>
extends PathfinderGoal {
    protected final EntityCreature mob;
    private final double walkSpeedModifier;
    private final double sprintSpeedModifier;
    protected @Nullable T toAvoid;
    protected final float maxDist;
    protected @Nullable PathEntity path;
    protected final NavigationAbstract pathNav;
    protected final Class<T> avoidClass;
    protected final Predicate<? super EntityLiving> avoidPredicate;
    protected final Predicate<? super EntityLiving> predicateOnAvoidEntity;
    private final PathfinderTargetCondition avoidEntityTargeting;

    public PathfinderGoalAvoidTarget(EntityCreature var02, Class<T> var1, float var2, double var3, double var5) {
        this(var02, var1, var0 -> true, var2, var3, var5, IEntitySelector.NO_CREATIVE_OR_SPECTATOR);
    }

    public PathfinderGoalAvoidTarget(EntityCreature var0, Class<T> var1, Predicate<EntityLiving> var22, float var32, double var4, double var6, Predicate<? super EntityLiving> var8) {
        this.mob = var0;
        this.avoidClass = var1;
        this.avoidPredicate = var22;
        this.maxDist = var32;
        this.walkSpeedModifier = var4;
        this.sprintSpeedModifier = var6;
        this.predicateOnAvoidEntity = var8;
        this.pathNav = var0.getNavigation();
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        this.avoidEntityTargeting = PathfinderTargetCondition.forCombat().range(var32).selector((var2, var3) -> var8.test(var2) && var22.test(var2));
    }

    public PathfinderGoalAvoidTarget(EntityCreature var02, Class<T> var1, float var2, double var3, double var5, Predicate<? super EntityLiving> var7) {
        this(var02, var1, var0 -> true, var2, var3, var5, var7);
    }

    @Override
    public boolean canUse() {
        this.toAvoid = PathfinderGoalAvoidTarget.getServerLevel(this.mob).getNearestEntity(this.mob.level().getEntitiesOfClass(this.avoidClass, this.mob.getBoundingBox().inflate(this.maxDist, 3.0, this.maxDist), var0 -> true), this.avoidEntityTargeting, this.mob, this.mob.getX(), this.mob.getY(), this.mob.getZ());
        if (this.toAvoid == null) {
            return false;
        }
        Vec3D var02 = DefaultRandomPos.getPosAway(this.mob, 16, 7, ((Entity)this.toAvoid).position());
        if (var02 == null) {
            return false;
        }
        if (((Entity)this.toAvoid).distanceToSqr(var02.x, var02.y, var02.z) < ((Entity)this.toAvoid).distanceToSqr(this.mob)) {
            return false;
        }
        this.path = this.pathNav.createPath(var02.x, var02.y, var02.z, 0);
        return this.path != null;
    }

    @Override
    public boolean canContinueToUse() {
        return !this.pathNav.isDone();
    }

    @Override
    public void start() {
        this.pathNav.moveTo(this.path, this.walkSpeedModifier);
    }

    @Override
    public void stop() {
        this.toAvoid = null;
    }

    @Override
    public void tick() {
        if (this.mob.distanceToSqr((Entity)this.toAvoid) < 49.0) {
            this.mob.getNavigation().setSpeedModifier(this.sprintSpeedModifier);
        } else {
            this.mob.getNavigation().setSpeedModifier(this.walkSpeedModifier);
        }
    }
}

