/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.SpearAttack;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class SpearRetreat
extends Behavior<EntityCreature> {
    public static final int MIN_COOLDOWN_DISTANCE = 9;
    public static final int MAX_COOLDOWN_DISTANCE = 11;
    public static final int MAX_FLEEING_TIME = 100;
    double speedModifierWhenRepositioning;

    public SpearRetreat(double var0) {
        super(Map.of(MemoryModuleType.SPEAR_STATUS, MemoryStatus.VALUE_PRESENT), 100);
        this.speedModifierWhenRepositioning = var0;
    }

    private @Nullable EntityLiving getTarget(EntityCreature var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    private boolean ableToAttack(EntityCreature var0) {
        return this.getTarget(var0) != null && var0.getMainHandItem().has(DataComponents.KINETIC_WEAPON);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        double var6;
        if (!this.ableToAttack(var1) || var1.isUsingItem()) {
            return false;
        }
        if (var1.getBrain().getMemory(MemoryModuleType.SPEAR_STATUS).orElse(SpearAttack.a.APPROACH) != SpearAttack.a.RETREAT) {
            return false;
        }
        EntityLiving var2 = this.getTarget(var1);
        double var3 = var1.distanceToSqr(var2.getX(), var2.getY(), var2.getZ());
        int var5 = var1.isPassenger() ? 2 : 0;
        Vec3D var8 = LandRandomPos.getPosAway(var1, Math.max(0.0, (double)(9 + var5) - (var6 = Math.sqrt(var3))), Math.max(1.0, (double)(11 + var5) - var6), 7, var2.position());
        if (var8 == null) {
            return false;
        }
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_POSITION, var8);
        return true;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        var1.setAggressive(true);
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_TIME, 0);
        super.start(var0, var1, var2);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return var1.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_TIME).orElse(100) < 100 && var1.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_POSITION).isPresent() && !var1.getNavigation().isDone() && this.ableToAttack(var1);
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var22) {
        float f2;
        EntityLiving var4 = this.getTarget(var1);
        Entity var5 = var1.getRootVehicle();
        if (var5 instanceof EntityInsentient) {
            EntityInsentient var7 = (EntityInsentient)var5;
            f2 = var7.chargeSpeedModifier();
        } else {
            f2 = 1.0f;
        }
        float var6 = f2;
        var1.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var4, true));
        var1.getBrain().setMemory(MemoryModuleType.SPEAR_FLEEING_TIME, var1.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_TIME).orElse(0) + 1);
        var1.getBrain().getMemory(MemoryModuleType.SPEAR_FLEEING_POSITION).ifPresent(var2 -> var1.getNavigation().moveTo(var2.x, var2.y, var2.z, (double)var6 * this.speedModifierWhenRepositioning));
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        var1.getNavigation().stop();
        var1.setAggressive(false);
        var1.stopUsingItem();
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_FLEEING_TIME);
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_FLEEING_POSITION);
        var1.getBrain().eraseMemory(MemoryModuleType.SPEAR_STATUS);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

