/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jspecify.annotations.Nullable;

public class AttributeModifiable {
    private final Holder<AttributeBase> attribute;
    private final Map<AttributeModifier.Operation, Map<MinecraftKey, AttributeModifier>> modifiersByOperation = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<MinecraftKey, AttributeModifier> modifierById = new Object2ObjectArrayMap();
    private final Map<MinecraftKey, AttributeModifier> permanentModifiers = new Object2ObjectArrayMap();
    private double baseValue;
    private boolean dirty = true;
    private double cachedValue;
    private final Consumer<AttributeModifiable> onDirty;

    public AttributeModifiable(Holder<AttributeBase> var0, Consumer<AttributeModifiable> var1) {
        this.attribute = var0;
        this.onDirty = var1;
        this.baseValue = var0.value().getDefaultValue();
    }

    public Holder<AttributeBase> getAttribute() {
        return this.attribute;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double var0) {
        if (var0 == this.baseValue) {
            return;
        }
        this.baseValue = var0;
        this.setDirty();
    }

    @VisibleForTesting
    Map<MinecraftKey, AttributeModifier> getModifiers(AttributeModifier.Operation var02) {
        return this.modifiersByOperation.computeIfAbsent(var02, var0 -> new Object2ObjectOpenHashMap());
    }

    public Set<AttributeModifier> getModifiers() {
        return ImmutableSet.copyOf(this.modifierById.values());
    }

    public Set<AttributeModifier> getPermanentModifiers() {
        return ImmutableSet.copyOf(this.permanentModifiers.values());
    }

    public @Nullable AttributeModifier getModifier(MinecraftKey var0) {
        return this.modifierById.get(var0);
    }

    public boolean hasModifier(MinecraftKey var0) {
        return this.modifierById.get(var0) != null;
    }

    private void addModifier(AttributeModifier var0) {
        AttributeModifier var1 = this.modifierById.putIfAbsent(var0.id(), var0);
        if (var1 != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.getModifiers(var0.operation()).put(var0.id(), var0);
        this.setDirty();
    }

    public void addOrUpdateTransientModifier(AttributeModifier var0) {
        AttributeModifier var1 = this.modifierById.put(var0.id(), var0);
        if (var0 == var1) {
            return;
        }
        this.getModifiers(var0.operation()).put(var0.id(), var0);
        this.setDirty();
    }

    public void addTransientModifier(AttributeModifier var0) {
        this.addModifier(var0);
    }

    public void addOrReplacePermanentModifier(AttributeModifier var0) {
        this.removeModifier(var0.id());
        this.addModifier(var0);
        this.permanentModifiers.put(var0.id(), var0);
    }

    public void addPermanentModifier(AttributeModifier var0) {
        this.addModifier(var0);
        this.permanentModifiers.put(var0.id(), var0);
    }

    public void addPermanentModifiers(Collection<AttributeModifier> var0) {
        for (AttributeModifier var2 : var0) {
            this.addPermanentModifier(var2);
        }
    }

    protected void setDirty() {
        this.dirty = true;
        this.onDirty.accept(this);
    }

    public void removeModifier(AttributeModifier var0) {
        this.removeModifier(var0.id());
    }

    public boolean removeModifier(MinecraftKey var0) {
        AttributeModifier var1 = this.modifierById.remove(var0);
        if (var1 == null) {
            return false;
        }
        this.getModifiers(var1.operation()).remove(var0);
        this.permanentModifiers.remove(var0);
        this.setDirty();
        return true;
    }

    public void removeModifiers() {
        for (AttributeModifier var1 : this.getModifiers()) {
            this.removeModifier(var1);
        }
    }

    public double getValue() {
        if (this.dirty) {
            this.cachedValue = this.calculateValue();
            this.dirty = false;
        }
        return this.cachedValue;
    }

    private double calculateValue() {
        double var0 = this.getBaseValue();
        for (AttributeModifier var3 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_VALUE)) {
            var0 += var3.amount();
        }
        double var2 = var0;
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
            var2 += var0 * var5.amount();
        }
        for (AttributeModifier var5 : this.getModifiersOrEmpty(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
            var2 *= 1.0 + var5.amount();
        }
        return this.attribute.value().sanitizeValue(var2);
    }

    private Collection<AttributeModifier> getModifiersOrEmpty(AttributeModifier.Operation var0) {
        return this.modifiersByOperation.getOrDefault(var0, Map.of()).values();
    }

    public void replaceFrom(AttributeModifiable var02) {
        this.baseValue = var02.baseValue;
        this.modifierById.clear();
        this.modifierById.putAll(var02.modifierById);
        this.permanentModifiers.clear();
        this.permanentModifiers.putAll(var02.permanentModifiers);
        this.modifiersByOperation.clear();
        var02.modifiersByOperation.forEach((var0, var1) -> this.getModifiers((AttributeModifier.Operation)var0).putAll((Map<MinecraftKey, AttributeModifier>)var1));
        this.setDirty();
    }

    public a pack() {
        return new a(this.attribute, this.baseValue, List.copyOf(this.permanentModifiers.values()));
    }

    public void apply(a var0) {
        this.baseValue = var0.baseValue;
        for (AttributeModifier var2 : var0.modifiers) {
            this.modifierById.put(var2.id(), var2);
            this.getModifiers(var2.operation()).put(var2.id(), var2);
            this.permanentModifiers.put(var2.id(), var2);
        }
        this.setDirty();
    }

    public static final class a
    extends Record {
        private final Holder<AttributeBase> attribute;
        final double baseValue;
        final List<AttributeModifier> modifiers;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("id").forGetter(a::attribute), (App)Codec.DOUBLE.fieldOf("base").orElse((Object)0.0).forGetter(a::baseValue), (App)AttributeModifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(a::modifiers)).apply((Applicative)var0, a::new));
        public static final Codec<List<a>> LIST_CODEC = CODEC.listOf();

        public a(Holder<AttributeBase> var0, double var1, List<AttributeModifier> var3) {
            this.attribute = var0;
            this.baseValue = var1;
            this.modifiers = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "attribute", "baseValue", "modifiers"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "attribute", "baseValue", "modifiers"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "attribute;baseValue;modifiers", "attribute", "baseValue", "modifiers"}, this, var0);
        }

        public Holder<AttributeBase> attribute() {
            return this.attribute;
        }

        public double baseValue() {
            return this.baseValue;
        }

        public List<AttributeModifier> modifiers() {
            return this.modifiers;
        }
    }
}

