/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.bee.EntityBee;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.cow.EntityCow;
import net.minecraft.world.entity.animal.dolphin.EntityDolphin;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.equine.EntityHorseZombie;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.fish.EntityFish;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.golem.CopperGolem;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.golem.EntitySnowman;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.Nautilus;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilus;
import net.minecraft.world.entity.animal.panda.EntityPanda;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.pig.EntityPig;
import net.minecraft.world.entity.animal.polarbear.EntityPolarBear;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.animal.squid.EntitySquid;
import net.minecraft.world.entity.animal.squid.GlowSquid;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.illager.EntityEvoker;
import net.minecraft.world.entity.monster.illager.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.illager.EntityPillager;
import net.minecraft.world.entity.monster.illager.EntityVindicator;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.skeleton.Bogged;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.spider.EntityCaveSpider;
import net.minecraft.world.entity.monster.spider.EntitySpider;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.zombie.EntityDrowned;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import org.slf4j.Logger;

public class AttributeDefaults {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<EntityTypes<? extends EntityLiving>, AttributeProvider> SUPPLIERS = ImmutableMap.builder().put(EntityTypes.ALLAY, (Object)Allay.createAttributes().build()).put(EntityTypes.ARMADILLO, (Object)Armadillo.createAttributes().build()).put(EntityTypes.ARMOR_STAND, (Object)EntityArmorStand.createAttributes().build()).put(EntityTypes.AXOLOTL, (Object)Axolotl.createAttributes().build()).put(EntityTypes.BAT, (Object)EntityBat.createAttributes().build()).put(EntityTypes.BEE, (Object)EntityBee.createAttributes().build()).put(EntityTypes.BLAZE, (Object)EntityBlaze.createAttributes().build()).put(EntityTypes.BOGGED, (Object)Bogged.createAttributes().build()).put(EntityTypes.CAT, (Object)EntityCat.createAttributes().build()).put(EntityTypes.CAMEL, (Object)Camel.createAttributes().build()).put(EntityTypes.CAMEL_HUSK, (Object)Camel.createAttributes().build()).put(EntityTypes.CAVE_SPIDER, (Object)EntityCaveSpider.createCaveSpider().build()).put(EntityTypes.CHICKEN, (Object)EntityChicken.createAttributes().build()).put(EntityTypes.COD, (Object)EntityFish.createAttributes().build()).put(EntityTypes.COPPER_GOLEM, (Object)CopperGolem.createAttributes().build()).put(EntityTypes.COW, (Object)EntityCow.createAttributes().build()).put(EntityTypes.CREAKING, (Object)Creaking.createAttributes().build()).put(EntityTypes.CREEPER, (Object)EntityCreeper.createAttributes().build()).put(EntityTypes.DOLPHIN, (Object)EntityDolphin.createAttributes().build()).put(EntityTypes.DONKEY, (Object)EntityHorseChestedAbstract.createBaseChestedHorseAttributes().build()).put(EntityTypes.DROWNED, (Object)EntityDrowned.createAttributes().build()).put(EntityTypes.ELDER_GUARDIAN, (Object)EntityGuardianElder.createAttributes().build()).put(EntityTypes.ENDERMAN, (Object)EntityEnderman.createAttributes().build()).put(EntityTypes.ENDERMITE, (Object)EntityEndermite.createAttributes().build()).put(EntityTypes.ENDER_DRAGON, (Object)EntityEnderDragon.createAttributes().build()).put(EntityTypes.EVOKER, (Object)EntityEvoker.createAttributes().build()).put(EntityTypes.BREEZE, (Object)Breeze.createAttributes().build()).put(EntityTypes.FOX, (Object)EntityFox.createAttributes().build()).put(EntityTypes.FROG, (Object)Frog.createAttributes().build()).put(EntityTypes.GHAST, (Object)EntityGhast.createAttributes().build()).put(EntityTypes.HAPPY_GHAST, (Object)HappyGhast.createAttributes().build()).put(EntityTypes.GIANT, (Object)EntityGiantZombie.createAttributes().build()).put(EntityTypes.GLOW_SQUID, (Object)GlowSquid.createAttributes().build()).put(EntityTypes.GOAT, (Object)Goat.createAttributes().build()).put(EntityTypes.GUARDIAN, (Object)EntityGuardian.createAttributes().build()).put(EntityTypes.HOGLIN, (Object)EntityHoglin.createAttributes().build()).put(EntityTypes.HORSE, (Object)EntityHorseAbstract.createBaseHorseAttributes().build()).put(EntityTypes.HUSK, (Object)EntityZombie.createAttributes().build()).put(EntityTypes.ILLUSIONER, (Object)EntityIllagerIllusioner.createAttributes().build()).put(EntityTypes.IRON_GOLEM, (Object)EntityIronGolem.createAttributes().build()).put(EntityTypes.LLAMA, (Object)EntityLlama.createAttributes().build()).put(EntityTypes.MAGMA_CUBE, (Object)EntityMagmaCube.createAttributes().build()).put(EntityTypes.MANNEQUIN, (Object)EntityLiving.createLivingAttributes().build()).put(EntityTypes.MOOSHROOM, (Object)EntityCow.createAttributes().build()).put(EntityTypes.MULE, (Object)EntityHorseChestedAbstract.createBaseChestedHorseAttributes().build()).put(EntityTypes.NAUTILUS, (Object)Nautilus.createAttributes().build()).put(EntityTypes.OCELOT, (Object)EntityOcelot.createAttributes().build()).put(EntityTypes.PANDA, (Object)EntityPanda.createAttributes().build()).put(EntityTypes.PARCHED, (Object)Parched.createAttributes().build()).put(EntityTypes.PARROT, (Object)EntityParrot.createAttributes().build()).put(EntityTypes.PHANTOM, (Object)EntityMonster.createMonsterAttributes().build()).put(EntityTypes.PIG, (Object)EntityPig.createAttributes().build()).put(EntityTypes.PIGLIN, (Object)EntityPiglin.createAttributes().build()).put(EntityTypes.PIGLIN_BRUTE, (Object)EntityPiglinBrute.createAttributes().build()).put(EntityTypes.PILLAGER, (Object)EntityPillager.createAttributes().build()).put(EntityTypes.PLAYER, (Object)EntityHuman.createAttributes().build()).put(EntityTypes.POLAR_BEAR, (Object)EntityPolarBear.createAttributes().build()).put(EntityTypes.PUFFERFISH, (Object)EntityFish.createAttributes().build()).put(EntityTypes.RABBIT, (Object)EntityRabbit.createAttributes().build()).put(EntityTypes.RAVAGER, (Object)EntityRavager.createAttributes().build()).put(EntityTypes.SALMON, (Object)EntityFish.createAttributes().build()).put(EntityTypes.SHEEP, (Object)EntitySheep.createAttributes().build()).put(EntityTypes.SHULKER, (Object)EntityShulker.createAttributes().build()).put(EntityTypes.SILVERFISH, (Object)EntitySilverfish.createAttributes().build()).put(EntityTypes.SKELETON, (Object)EntitySkeletonAbstract.createAttributes().build()).put(EntityTypes.SKELETON_HORSE, (Object)EntityHorseSkeleton.createAttributes().build()).put(EntityTypes.SLIME, (Object)EntityMonster.createMonsterAttributes().build()).put(EntityTypes.SNIFFER, (Object)Sniffer.createAttributes().build()).put(EntityTypes.SNOW_GOLEM, (Object)EntitySnowman.createAttributes().build()).put(EntityTypes.SPIDER, (Object)EntitySpider.createAttributes().build()).put(EntityTypes.SQUID, (Object)EntitySquid.createAttributes().build()).put(EntityTypes.STRAY, (Object)EntitySkeletonAbstract.createAttributes().build()).put(EntityTypes.STRIDER, (Object)EntityStrider.createAttributes().build()).put(EntityTypes.TADPOLE, (Object)Tadpole.createAttributes().build()).put(EntityTypes.TRADER_LLAMA, (Object)EntityLlama.createAttributes().build()).put(EntityTypes.TROPICAL_FISH, (Object)EntityFish.createAttributes().build()).put(EntityTypes.TURTLE, (Object)EntityTurtle.createAttributes().build()).put(EntityTypes.VEX, (Object)EntityVex.createAttributes().build()).put(EntityTypes.VILLAGER, (Object)EntityVillager.createAttributes().build()).put(EntityTypes.VINDICATOR, (Object)EntityVindicator.createAttributes().build()).put(EntityTypes.WARDEN, (Object)Warden.createAttributes().build()).put(EntityTypes.WANDERING_TRADER, (Object)EntityInsentient.createMobAttributes().build()).put(EntityTypes.WITCH, (Object)EntityWitch.createAttributes().build()).put(EntityTypes.WITHER, (Object)EntityWither.createAttributes().build()).put(EntityTypes.WITHER_SKELETON, (Object)EntitySkeletonAbstract.createAttributes().build()).put(EntityTypes.WOLF, (Object)EntityWolf.createAttributes().build()).put(EntityTypes.ZOGLIN, (Object)EntityZoglin.createAttributes().build()).put(EntityTypes.ZOMBIE, (Object)EntityZombie.createAttributes().build()).put(EntityTypes.ZOMBIE_HORSE, (Object)EntityHorseZombie.createAttributes().build()).put(EntityTypes.ZOMBIE_NAUTILUS, (Object)ZombieNautilus.createAttributes().build()).put(EntityTypes.ZOMBIE_VILLAGER, (Object)EntityZombie.createAttributes().build()).put(EntityTypes.ZOMBIFIED_PIGLIN, (Object)EntityPigZombie.createAttributes().build()).build();

    public static AttributeProvider getSupplier(EntityTypes<? extends EntityLiving> var0) {
        return SUPPLIERS.get(var0);
    }

    public static boolean hasSupplier(EntityTypes<?> var0) {
        return SUPPLIERS.containsKey(var0);
    }

    public static void validate() {
        BuiltInRegistries.ENTITY_TYPE.stream().filter(var0 -> var0.getCategory() != EnumCreatureType.MISC).filter(var0 -> !AttributeDefaults.hasSupplier(var0)).map(BuiltInRegistries.ENTITY_TYPE::getKey).forEach(var0 -> SystemUtils.logAndPauseIfInIde("Entity " + String.valueOf(var0) + " has no attributes"));
    }
}

