/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public interface IEntityAngerable {
    public static final String TAG_ANGER_END_TIME = "anger_end_time";
    public static final String TAG_ANGRY_AT = "angry_at";
    public static final long NO_ANGER_END_TIME = -1L;

    public long getPersistentAngerEndTime();

    default public void setTimeToRemainAngry(long var0) {
        this.setPersistentAngerEndTime(this.level().getGameTime() + var0);
    }

    public void setPersistentAngerEndTime(long var1);

    public @Nullable EntityReference<EntityLiving> getPersistentAngerTarget();

    public void setPersistentAngerTarget(@Nullable EntityReference<EntityLiving> var1);

    public void startPersistentAngerTimer();

    public World level();

    default public void addPersistentAngerSaveData(ValueOutput var0) {
        var0.putLong(TAG_ANGER_END_TIME, this.getPersistentAngerEndTime());
        var0.storeNullable(TAG_ANGRY_AT, EntityReference.codec(), this.getPersistentAngerTarget());
    }

    default public void readPersistentAngerSaveData(World var0, ValueInput var1) {
        Optional<Long> var2 = var1.getLong(TAG_ANGER_END_TIME);
        if (var2.isPresent()) {
            this.setPersistentAngerEndTime(var2.get());
        } else {
            Optional<Integer> var3 = var1.getInt("AngerTime");
            if (var3.isPresent()) {
                this.setTimeToRemainAngry(var3.get().intValue());
            } else {
                this.setPersistentAngerEndTime(-1L);
            }
        }
        if (!(var0 instanceof WorldServer)) {
            return;
        }
        this.setPersistentAngerTarget(EntityReference.read(var1, TAG_ANGRY_AT));
        this.setTarget(EntityReference.getLivingEntity(this.getPersistentAngerTarget(), var0));
    }

    default public void updatePersistentAnger(WorldServer var0, boolean var1) {
        EntityLiving var2 = this.getTarget();
        EntityReference<EntityLiving> var3 = this.getPersistentAngerTarget();
        if (var2 != null && var2.isDeadOrDying() && var3 != null && var3.matches(var2) && var2 instanceof EntityInsentient) {
            this.stopBeingAngry();
            return;
        }
        if (var2 != null) {
            if (var3 == null || !var3.matches(var2)) {
                this.setPersistentAngerTarget(EntityReference.of(var2));
            }
            this.startPersistentAngerTimer();
        }
        if (!(var3 == null || this.isAngry() || var2 != null && IEntityAngerable.isValidPlayerTarget(var2) && var1)) {
            this.stopBeingAngry();
        }
    }

    private static boolean isValidPlayerTarget(EntityLiving var0) {
        EntityHuman var1;
        return var0 instanceof EntityHuman && !(var1 = (EntityHuman)var0).isCreative() && !var1.isSpectator();
    }

    default public boolean isAngryAt(EntityLiving var0, WorldServer var1) {
        if (!this.canAttack(var0)) {
            return false;
        }
        if (IEntityAngerable.isValidPlayerTarget(var0) && this.isAngryAtAllPlayers(var1)) {
            return true;
        }
        EntityReference<EntityLiving> var2 = this.getPersistentAngerTarget();
        return var2 != null && var2.matches(var0);
    }

    default public boolean isAngryAtAllPlayers(WorldServer var0) {
        return var0.getGameRules().get(GameRules.UNIVERSAL_ANGER) != false && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    default public boolean isAngry() {
        long var0 = this.getPersistentAngerEndTime();
        if (var0 > 0L) {
            long var2 = var0 - this.level().getGameTime();
            return var2 > 0L;
        }
        return false;
    }

    default public void playerDied(WorldServer var0, EntityHuman var1) {
        if (!var0.getGameRules().get(GameRules.FORGIVE_DEAD_PLAYERS).booleanValue()) {
            return;
        }
        EntityReference<EntityLiving> var2 = this.getPersistentAngerTarget();
        if (var2 == null || !var2.matches(var1)) {
            return;
        }
        this.stopBeingAngry();
    }

    default public void forgetCurrentTargetAndRefreshUniversalAnger() {
        this.stopBeingAngry();
        this.startPersistentAngerTimer();
    }

    default public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setPersistentAngerEndTime(-1L);
    }

    public @Nullable EntityLiving getLastHurtByMob();

    public void setLastHurtByMob(@Nullable EntityLiving var1);

    public void setTarget(@Nullable EntityLiving var1);

    public boolean canAttack(EntityLiving var1);

    public @Nullable EntityLiving getTarget();
}

