/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntityLightning
extends Entity {
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    public int life = 2;
    public long seed;
    public int flashes;
    public boolean visualOnly;
    private @Nullable EntityPlayer cause;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    private int blocksSetOnFire;

    public EntityLightning(EntityTypes<? extends EntityLightning> var0, World var1) {
        super(var0, var1);
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    public void setVisualOnly(boolean var0) {
        this.visualOnly = var0;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.WEATHER;
    }

    public @Nullable EntityPlayer getCause() {
        return this.cause;
    }

    public void setCause(@Nullable EntityPlayer var0) {
        this.cause = var0;
    }

    private void powerLightningRod() {
        BlockPosition var0 = this.getStrikePosition();
        IBlockData var1 = this.level().getBlockState(var0);
        Block block = var1.getBlock();
        if (block instanceof LightningRodBlock) {
            LightningRodBlock var2 = (LightningRodBlock)block;
            var2.onLightningStrike(var1, this.level(), var0);
        }
    }

    @Override
    public void tick() {
        List<Entity> var02;
        super.tick();
        if (this.life == 2) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.LIGHTNING_BOLT_THUNDER, SoundCategory.WEATHER, 10000.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.LIGHTNING_BOLT_IMPACT, SoundCategory.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                EnumDifficulty var022 = this.level().getDifficulty();
                if (var022 == EnumDifficulty.NORMAL || var022 == EnumDifficulty.HARD) {
                    this.spawnFire(4);
                }
                this.powerLightningRod();
                EntityLightning.clearCopperOnLightningStrike(this.level(), this.getStrikePosition());
                this.gameEvent(GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.level() instanceof WorldServer) {
                    var02 = this.level().getEntities(this, new AxisAlignedBB(this.getX() - 15.0, this.getY() - 15.0, this.getZ() - 15.0, this.getX() + 15.0, this.getY() + 6.0 + 15.0, this.getZ() + 15.0), var0 -> var0.isAlive() && !this.hitEntities.contains(var0));
                    for (EntityPlayer entityPlayer : ((WorldServer)this.level()).getPlayers(var0 -> var0.distanceTo(this) < 256.0f)) {
                        CriterionTriggers.LIGHTNING_STRIKE.trigger(entityPlayer, this, var02);
                    }
                }
                this.discard();
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                this.spawnFire(0);
            }
        }
        if (this.life >= 0) {
            if (!(this.level() instanceof WorldServer)) {
                this.level().setSkyFlashTime(2);
            } else if (!this.visualOnly) {
                var02 = this.level().getEntities(this, new AxisAlignedBB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 6.0 + 3.0, this.getZ() + 3.0), Entity::isAlive);
                for (Entity entity : var02) {
                    entity.thunderHit((WorldServer)this.level(), this);
                }
                this.hitEntities.addAll(var02);
                if (this.cause != null) {
                    CriterionTriggers.CHANNELED_LIGHTNING.trigger(this.cause, var02);
                }
            }
        }
    }

    private BlockPosition getStrikePosition() {
        Vec3D var0 = this.position();
        return BlockPosition.containing(var0.x, var0.y - 1.0E-6, var0.z);
    }

    private void spawnFire(int var0) {
        World world;
        if (this.visualOnly || !((world = this.level()) instanceof WorldServer)) {
            return;
        }
        WorldServer var1 = (WorldServer)world;
        BlockPosition var2 = this.blockPosition();
        if (!var1.canSpreadFireAround(var2)) {
            return;
        }
        IBlockData var3 = BlockFireAbstract.getState(var1, var2);
        if (var1.getBlockState(var2).isAir() && var3.canSurvive(var1, var2)) {
            var1.setBlockAndUpdate(var2, var3);
            ++this.blocksSetOnFire;
        }
        for (int var4 = 0; var4 < var0; ++var4) {
            BlockPosition var5 = var2.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
            var3 = BlockFireAbstract.getState(var1, var5);
            if (!var1.getBlockState(var5).isAir() || !var3.canSurvive(var1, var5)) continue;
            var1.setBlockAndUpdate(var5, var3);
            ++this.blocksSetOnFire;
        }
    }

    private static void clearCopperOnLightningStrike(World var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        boolean var3 = HoneycombItem.WAX_OFF_BY_BLOCK.get().get((Object)var2.getBlock()) != null;
        boolean var4 = var2.getBlock() instanceof WeatheringCopper;
        if (!var4 && !var3) {
            return;
        }
        if (var4) {
            var0.setBlockAndUpdate(var1, WeatheringCopper.getFirst(var0.getBlockState(var1)));
        }
        BlockPosition.MutableBlockPosition var5 = var1.mutable();
        int var6 = var0.random.nextInt(3) + 3;
        for (int var7 = 0; var7 < var6; ++var7) {
            int var8 = var0.random.nextInt(8) + 1;
            EntityLightning.randomWalkCleaningCopper(var0, var1, var5, var8);
        }
    }

    private static void randomWalkCleaningCopper(World var0, BlockPosition var1, BlockPosition.MutableBlockPosition var2, int var3) {
        Optional<BlockPosition> var5;
        var2.set(var1);
        for (int var4 = 0; var4 < var3 && !(var5 = EntityLightning.randomStepCleaningCopper(var0, var2)).isEmpty(); ++var4) {
            var2.set(var5.get());
        }
    }

    private static Optional<BlockPosition> randomStepCleaningCopper(World var0, BlockPosition var1) {
        for (BlockPosition var3 : BlockPosition.randomInCube(var0.random, 10, var1, 1)) {
            IBlockData var4 = var0.getBlockState(var3);
            if (!(var4.getBlock() instanceof WeatheringCopper)) continue;
            WeatheringCopper.getPrevious(var4).ifPresent(var2 -> var0.setBlockAndUpdate(var3, (IBlockData)var2));
            var0.levelEvent(3002, var3, -1);
            return Optional.of(var3);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = 64.0 * EntityLightning.getViewScale();
        return var0 < var2 * var2;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
    }

    public int getBlocksSetOnFire() {
        return this.blocksSetOnFire;
    }

    public Stream<Entity> getHitEntities() {
        return this.hitEntities.stream().filter(Entity::isAlive);
    }

    @Override
    public final boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        return false;
    }
}

