/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.jspecify.annotations.Nullable;

public class MobEffectList
implements FeatureElement {
    public static final Codec<Holder<MobEffectList>> CODEC = BuiltInRegistries.MOB_EFFECT.holderByNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MobEffectList>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.MOB_EFFECT);
    private static final int AMBIENT_ALPHA = MathHelper.floor(38.25f);
    private final Map<Holder<AttributeBase>, a> attributeModifiers = new Object2ObjectOpenHashMap();
    private final MobEffectInfo category;
    private final int color;
    private final Function<MobEffect, ParticleParam> particleFactory;
    private @Nullable String descriptionId;
    private int blendInDurationTicks;
    private int blendOutDurationTicks;
    private int blendOutAdvanceTicks;
    private Optional<SoundEffect> soundOnAdded = Optional.empty();
    private FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;

    protected MobEffectList(MobEffectInfo var0, int var12) {
        this.category = var0;
        this.color = var12;
        this.particleFactory = var1 -> {
            int var2 = var1.isAmbient() ? AMBIENT_ALPHA : 255;
            return ColorParticleOption.create(Particles.ENTITY_EFFECT, ARGB.color(var2, var12));
        };
    }

    protected MobEffectList(MobEffectInfo var0, int var12, ParticleParam var2) {
        this.category = var0;
        this.color = var12;
        this.particleFactory = var1 -> var2;
    }

    public int getBlendInDurationTicks() {
        return this.blendInDurationTicks;
    }

    public int getBlendOutDurationTicks() {
        return this.blendOutDurationTicks;
    }

    public int getBlendOutAdvanceTicks() {
        return this.blendOutAdvanceTicks;
    }

    public boolean applyEffectTick(WorldServer var0, EntityLiving var1, int var2) {
        return true;
    }

    public void applyInstantenousEffect(WorldServer var0, @Nullable Entity var1, @Nullable Entity var2, EntityLiving var3, int var4, double var5) {
        this.applyEffectTick(var0, var3, var4);
    }

    public boolean shouldApplyEffectTickThisTick(int var0, int var1) {
        return false;
    }

    public void onEffectStarted(EntityLiving var0, int var1) {
    }

    public void onEffectAdded(EntityLiving var0, int var12) {
        this.soundOnAdded.ifPresent(var1 -> var0.level().playSound(null, var0.getX(), var0.getY(), var0.getZ(), (SoundEffect)var1, var0.getSoundSource(), 1.0f, 1.0f));
    }

    public void onMobRemoved(WorldServer var0, EntityLiving var1, int var2, Entity.RemovalReason var3) {
    }

    public void onMobHurt(WorldServer var0, EntityLiving var1, int var2, DamageSource var3, float var4) {
    }

    public boolean isInstantenous() {
        return false;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("effect", BuiltInRegistries.MOB_EFFECT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable(this.getDescriptionId());
    }

    public MobEffectInfo getCategory() {
        return this.category;
    }

    public int getColor() {
        return this.color;
    }

    public MobEffectList addAttributeModifier(Holder<AttributeBase> var0, MinecraftKey var1, double var2, AttributeModifier.Operation var4) {
        this.attributeModifiers.put(var0, new a(var1, var2, var4));
        return this;
    }

    public MobEffectList setBlendDuration(int var0) {
        return this.setBlendDuration(var0, var0, var0);
    }

    public MobEffectList setBlendDuration(int var0, int var1, int var2) {
        this.blendInDurationTicks = var0;
        this.blendOutDurationTicks = var1;
        this.blendOutAdvanceTicks = var2;
        return this;
    }

    public void createModifiers(int var0, BiConsumer<Holder<AttributeBase>, AttributeModifier> var1) {
        this.attributeModifiers.forEach((var2, var3) -> var1.accept((Holder<AttributeBase>)var2, var3.create(var0)));
    }

    public void removeAttributeModifiers(AttributeMapBase var0) {
        for (Map.Entry<Holder<AttributeBase>, a> var2 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var3 = var0.getInstance(var2.getKey());
            if (var3 == null) continue;
            var3.removeModifier(var2.getValue().id());
        }
    }

    public void addAttributeModifiers(AttributeMapBase var0, int var1) {
        for (Map.Entry<Holder<AttributeBase>, a> var3 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var4 = var0.getInstance(var3.getKey());
            if (var4 == null) continue;
            var4.removeModifier(var3.getValue().id());
            var4.addPermanentModifier(var3.getValue().create(var1));
        }
    }

    public boolean isBeneficial() {
        return this.category == MobEffectInfo.BENEFICIAL;
    }

    public ParticleParam createParticleOptions(MobEffect var0) {
        return this.particleFactory.apply(var0);
    }

    public MobEffectList withSoundOnAdded(SoundEffect var0) {
        this.soundOnAdded = Optional.of(var0);
        return this;
    }

    public MobEffectList requiredFeatures(FeatureFlag ... var0) {
        this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
        return this;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    record a(MinecraftKey id, double amount, AttributeModifier.Operation operation) {
        public AttributeModifier create(int var0) {
            return new AttributeModifier(this.id, this.amount * (double)(var0 + 1), this.operation);
        }
    }
}

