/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.server.level.WorldServer;
import net.minecraft.world.effect.InstantMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.jspecify.annotations.Nullable;

class HealOrHarmMobEffect
extends InstantMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectInfo var0, int var1, boolean var2) {
        super(var0, var1);
        this.isHarm = var2;
    }

    @Override
    public boolean applyEffectTick(WorldServer var0, EntityLiving var1, int var2) {
        if (this.isHarm == var1.isInvertedHealAndHarm()) {
            var1.heal(Math.max(4 << var2, 0));
        } else {
            var1.hurtServer(var0, var1.damageSources().magic(), 6 << var2);
        }
        return true;
    }

    @Override
    public void applyInstantenousEffect(WorldServer var0, @Nullable Entity var1, @Nullable Entity var2, EntityLiving var3, int var4, double var5) {
        if (this.isHarm == var3.isInvertedHealAndHarm()) {
            int var7 = (int)(var5 * (double)(4 << var4) + 0.5);
            var3.heal(var7);
        } else {
            int var7 = (int)(var5 * (double)(6 << var4) + 0.5);
            if (var1 == null) {
                var3.hurtServer(var0, var3.damageSources().magic(), var7);
            } else {
                var3.hurtServer(var0, var3.damageSources().indirectMagic(var1, var2), var7);
            }
        }
    }
}

