/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.LerpFunction;
import net.minecraft.world.attribute.modifier.AttributeModifier;

public interface ColorModifier<Argument>
extends AttributeModifier<Integer, Argument> {
    public static final ColorModifier<Integer> ALPHA_BLEND = new ColorModifier<Integer>(){

        @Override
        public Integer apply(Integer var0, Integer var1) {
            return ARGB.alphaBlend(var0, var1);
        }

        @Override
        public Codec<Integer> argumentCodec(EnvironmentAttribute<Integer> var0) {
            return ExtraCodecs.STRING_ARGB_COLOR;
        }

        @Override
        public LerpFunction<Integer> argumentKeyframeLerp(EnvironmentAttribute<Integer> var0) {
            return LerpFunction.ofColor();
        }

        @Override
        public /* synthetic */ Object apply(Object object, Object object2) {
            return this.apply((Integer)object, (Integer)object2);
        }
    };
    public static final ColorModifier<Integer> ADD = ARGB::addRgb;
    public static final ColorModifier<Integer> SUBTRACT = ARGB::subtractRgb;
    public static final ColorModifier<Integer> MULTIPLY_RGB = ARGB::multiply;
    public static final ColorModifier<Integer> MULTIPLY_ARGB = ARGB::multiply;
    public static final ColorModifier<b> BLEND_TO_GRAY = new ColorModifier<b>(){

        @Override
        public Integer apply(Integer var0, b var1) {
            int var2 = ARGB.scaleRGB(ARGB.greyscale(var0), var1.brightness);
            return ARGB.srgbLerp(var1.factor, var0, var2);
        }

        @Override
        public Codec<b> argumentCodec(EnvironmentAttribute<Integer> var0) {
            return b.CODEC;
        }

        @Override
        public LerpFunction<b> argumentKeyframeLerp(EnvironmentAttribute<Integer> var02) {
            return (var0, var1, var2) -> new b(MathHelper.lerp(var0, var1.brightness, var2.brightness), MathHelper.lerp(var0, var1.factor, var2.factor));
        }

        @Override
        public /* synthetic */ Object apply(Object object, Object object2) {
            return this.apply((Integer)object, (b)object2);
        }
    };

    @FunctionalInterface
    public static interface c
    extends ColorModifier<Integer> {
        @Override
        default public Codec<Integer> argumentCodec(EnvironmentAttribute<Integer> var0) {
            return ExtraCodecs.STRING_RGB_COLOR;
        }

        @Override
        default public LerpFunction<Integer> argumentKeyframeLerp(EnvironmentAttribute<Integer> var0) {
            return LerpFunction.ofColor();
        }
    }

    @FunctionalInterface
    public static interface a
    extends ColorModifier<Integer> {
        @Override
        default public Codec<Integer> argumentCodec(EnvironmentAttribute<Integer> var02) {
            return Codec.either(ExtraCodecs.STRING_ARGB_COLOR, ExtraCodecs.RGB_COLOR_CODEC).xmap(Either::unwrap, var0 -> ARGB.alpha(var0) == 255 ? Either.right((Object)var0) : Either.left((Object)var0));
        }

        @Override
        default public LerpFunction<Integer> argumentKeyframeLerp(EnvironmentAttribute<Integer> var0) {
            return LerpFunction.ofColor();
        }
    }

    public static final class b
    extends Record {
        final float brightness;
        final float factor;
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("brightness").forGetter(b::brightness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("factor").forGetter(b::factor)).apply((Applicative)var0, b::new));

        public b(float var0, float var1) {
            this.brightness = var0;
            this.factor = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "brightness;factor", "brightness", "factor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "brightness;factor", "brightness", "factor"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "brightness;factor", "brightness", "factor"}, this, var0);
        }

        public float brightness() {
            return this.brightness;
        }

        public float factor() {
            return this.factor;
        }
    }
}

