/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.util.ARGB;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.ColorModifier;
import net.minecraft.world.attribute.modifier.FloatModifier;
import net.minecraft.world.attribute.modifier.FloatWithAlpha;
import net.minecraft.world.level.World;
import net.minecraft.world.timeline.Timelines;

public class WeatherAttributes {
    public static final EnvironmentAttributeMap RAIN = EnvironmentAttributeMap.builder().modify(EnvironmentAttributes.SKY_COLOR, ColorModifier.BLEND_TO_GRAY, new ColorModifier.b(0.6f, 0.75f)).modify(EnvironmentAttributes.FOG_COLOR, ColorModifier.MULTIPLY_RGB, ARGB.colorFromFloat(1.0f, 0.5f, 0.5f, 0.6f)).modify(EnvironmentAttributes.CLOUD_COLOR, ColorModifier.BLEND_TO_GRAY, new ColorModifier.b(0.24f, 0.5f)).modify(EnvironmentAttributes.SKY_LIGHT_LEVEL, FloatModifier.ALPHA_BLEND, new FloatWithAlpha(4.0f, 0.3125f)).modify(EnvironmentAttributes.SKY_LIGHT_COLOR, ColorModifier.ALPHA_BLEND, ARGB.color(0.3125f, Timelines.NIGHT_SKY_LIGHT_COLOR)).modify(EnvironmentAttributes.SKY_LIGHT_FACTOR, FloatModifier.ALPHA_BLEND, new FloatWithAlpha(0.24f, 0.3125f)).set(EnvironmentAttributes.STAR_BRIGHTNESS, Float.valueOf(0.0f)).modify(EnvironmentAttributes.SUNRISE_SUNSET_COLOR, ColorModifier.MULTIPLY_ARGB, ARGB.colorFromFloat(1.0f, 0.5f, 0.5f, 0.6f)).set(EnvironmentAttributes.BEES_STAY_IN_HIVE, true).build();
    public static final EnvironmentAttributeMap THUNDER = EnvironmentAttributeMap.builder().modify(EnvironmentAttributes.SKY_COLOR, ColorModifier.BLEND_TO_GRAY, new ColorModifier.b(0.24f, 0.94f)).modify(EnvironmentAttributes.FOG_COLOR, ColorModifier.MULTIPLY_RGB, ARGB.colorFromFloat(1.0f, 0.25f, 0.25f, 0.3f)).modify(EnvironmentAttributes.CLOUD_COLOR, ColorModifier.BLEND_TO_GRAY, new ColorModifier.b(0.095f, 0.94f)).modify(EnvironmentAttributes.SKY_LIGHT_LEVEL, FloatModifier.ALPHA_BLEND, new FloatWithAlpha(4.0f, 0.52734375f)).modify(EnvironmentAttributes.SKY_LIGHT_COLOR, ColorModifier.ALPHA_BLEND, ARGB.color(0.52734375f, Timelines.NIGHT_SKY_LIGHT_COLOR)).modify(EnvironmentAttributes.SKY_LIGHT_FACTOR, FloatModifier.ALPHA_BLEND, new FloatWithAlpha(0.24f, 0.52734375f)).set(EnvironmentAttributes.STAR_BRIGHTNESS, Float.valueOf(0.0f)).modify(EnvironmentAttributes.SUNRISE_SUNSET_COLOR, ColorModifier.MULTIPLY_ARGB, ARGB.colorFromFloat(1.0f, 0.25f, 0.25f, 0.3f)).set(EnvironmentAttributes.BEES_STAY_IN_HIVE, true).build();
    private static final Set<EnvironmentAttribute<?>> WEATHER_ATTRIBUTES = Sets.union(RAIN.keySet(), THUNDER.keySet());

    public static void addBuiltinLayers(EnvironmentAttributeSystem.a var0, a var1) {
        for (EnvironmentAttribute<?> var3 : WEATHER_ATTRIBUTES) {
            WeatherAttributes.addLayer(var0, var1, var3);
        }
    }

    private static <Value> void addLayer(EnvironmentAttributeSystem.a var0, a var1, EnvironmentAttribute<Value> var2) {
        EnvironmentAttributeMap.b var3 = RAIN.get(var2);
        EnvironmentAttributeMap.b var42 = THUNDER.get(var2);
        var0.addTimeBasedLayer(var2, (var4, var5) -> {
            Object var8;
            float var6 = var1.thunderLevel();
            float var7 = var1.rainLevel() - var6;
            if (var3 != null && var7 > 0.0f) {
                var8 = var3.applyModifier(var4);
                var4 = var2.type().stateChangeLerp().apply(var7, var4, var8);
            }
            if (var42 != null && var6 > 0.0f) {
                var8 = var42.applyModifier(var4);
                var4 = var2.type().stateChangeLerp().apply(var6, var4, var8);
            }
            return var4;
        });
    }

    public static interface a {
        public static a from(final World var0) {
            return new a(){

                @Override
                public float rainLevel() {
                    return var0.getRainLevel(1.0f);
                }

                @Override
                public float thunderLevel() {
                    return var0.getThunderLevel(1.0f);
                }
            };
        }

        public float rainLevel();

        public float thunderLevel();
    }
}

