/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import net.minecraft.util.ARGB;
import net.minecraft.util.MathHelper;

public interface LerpFunction<T> {
    public static LerpFunction<Float> ofFloat() {
        return MathHelper::lerp;
    }

    public static LerpFunction<Float> ofDegrees(float var0) {
        return (var1, var2, var3) -> {
            float var4 = MathHelper.wrapDegrees(var3.floatValue() - var2.floatValue());
            if (Math.abs(var4) >= var0) {
                return var3;
            }
            return Float.valueOf(var2.floatValue() + var1 * var4);
        };
    }

    public static <T> LerpFunction<T> ofConstant() {
        return (var0, var1, var2) -> var1;
    }

    public static <T> LerpFunction<T> ofStep(float var0) {
        return (var1, var2, var3) -> var1 >= var0 ? var3 : var2;
    }

    public static LerpFunction<Integer> ofColor() {
        return ARGB::srgbLerp;
    }

    public T apply(float var1, T var2, T var3);
}

