/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeLayer;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.attribute.SpatialAttributeInterpolator;
import net.minecraft.world.attribute.WeatherAttributes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.timeline.Timeline;
import org.jspecify.annotations.Nullable;

public class EnvironmentAttributeSystem
implements EnvironmentAttributeReader {
    private final Map<EnvironmentAttribute<?>, b<?>> attributeSamplers = new Reference2ObjectOpenHashMap();

    EnvironmentAttributeSystem(Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> var02) {
        var02.forEach((var0, var1) -> this.attributeSamplers.put((EnvironmentAttribute<?>)var0, this.bakeLayerSampler((EnvironmentAttribute)var0, (List<? extends EnvironmentAttributeLayer<?>>)var1)));
    }

    private <Value> b<Value> bakeLayerSampler(EnvironmentAttribute<Value> var02, List<? extends EnvironmentAttributeLayer<?>> var1) {
        Object e2;
        ArrayList var2 = new ArrayList(var1);
        Value var3 = var02.defaultValue();
        while (!var2.isEmpty() && (e2 = var2.getFirst()) instanceof EnvironmentAttributeLayer.a) {
            EnvironmentAttributeLayer.a var4 = (EnvironmentAttributeLayer.a)e2;
            var3 = var4.applyConstant(var3);
            var2.removeFirst();
        }
        boolean var4 = var2.stream().anyMatch(var0 -> var0 instanceof EnvironmentAttributeLayer.b);
        return new b<Value>(var02, var3, List.copyOf(var2), var4);
    }

    public static a builder() {
        return new a();
    }

    static void addDefaultLayers(a var0, World var1) {
        IRegistryCustom var22 = var1.registryAccess();
        BiomeManager var3 = var1.getBiomeManager();
        LongSupplier var4 = var1::getDayTime;
        EnvironmentAttributeSystem.addDimensionLayer(var0, var1.dimensionType());
        EnvironmentAttributeSystem.addBiomeLayer(var0, var22.lookupOrThrow(Registries.BIOME), var3);
        var1.dimensionType().timelines().forEach(var2 -> var0.addTimelineLayer((Holder<Timeline>)var2, var4));
        if (var1.canHaveWeather()) {
            WeatherAttributes.addBuiltinLayers(var0, WeatherAttributes.a.from(var1));
        }
    }

    private static void addDimensionLayer(a var0, DimensionManager var1) {
        var0.addConstantLayer(var1.attributes());
    }

    private static void addBiomeLayer(a var02, HolderLookup<BiomeBase> var1, BiomeManager var22) {
        Stream var3 = var1.listElements().flatMap(var0 -> ((BiomeBase)var0.value()).getAttributes().keySet().stream()).distinct();
        var3.forEach(var2 -> EnvironmentAttributeSystem.addBiomeLayerForAttribute(var02, var2, var22));
    }

    private static <Value> void addBiomeLayerForAttribute(a var0, EnvironmentAttribute<Value> var1, BiomeManager var22) {
        var0.addPositionalLayer(var1, (var2, var3, var4) -> {
            if (var4 != null && var1.isSpatiallyInterpolated()) {
                return var4.applyAttributeLayer(var1, var2);
            }
            Holder<BiomeBase> var5 = var22.getNoiseBiomeAtPosition(var3.x, var3.y, var3.z);
            return var5.value().getAttributes().applyModifier(var1, var2);
        });
    }

    public void invalidateTickCache() {
        this.attributeSamplers.values().forEach(b::invalidateTickCache);
    }

    private <Value> @Nullable b<Value> getValueSampler(EnvironmentAttribute<Value> var0) {
        return this.attributeSamplers.get(var0);
    }

    @Override
    public <Value> Value getDimensionValue(EnvironmentAttribute<Value> var0) {
        if (SharedConstants.IS_RUNNING_IN_IDE && var0.isPositional()) {
            throw new IllegalStateException("Position must always be provided for positional attribute " + String.valueOf(var0));
        }
        b<Value> var1 = this.getValueSampler(var0);
        if (var1 == null) {
            return var0.defaultValue();
        }
        return var1.getDimensionValue();
    }

    @Override
    public <Value> Value getValue(EnvironmentAttribute<Value> var0, Vec3D var1, @Nullable SpatialAttributeInterpolator var2) {
        b<Value> var3 = this.getValueSampler(var0);
        if (var3 == null) {
            return var0.defaultValue();
        }
        return var3.getValue(var1, var2);
    }

    @VisibleForTesting
    <Value> Value getConstantBaseValue(EnvironmentAttribute<Value> var0) {
        b<Value> var1 = this.getValueSampler(var0);
        return var1 != null ? var1.baseValue : var0.defaultValue();
    }

    @VisibleForTesting
    boolean isAffectedByPosition(EnvironmentAttribute<?> var0) {
        b<?> var1 = this.getValueSampler(var0);
        return var1 != null && var1.isAffectedByPosition;
    }

    static class b<Value> {
        private final EnvironmentAttribute<Value> attribute;
        final Value baseValue;
        private final List<EnvironmentAttributeLayer<Value>> layers;
        final boolean isAffectedByPosition;
        private @Nullable Value cachedTickValue;
        private int cacheTickId;

        b(EnvironmentAttribute<Value> var0, Value var1, List<EnvironmentAttributeLayer<Value>> var2, boolean var3) {
            this.attribute = var0;
            this.baseValue = var1;
            this.layers = var2;
            this.isAffectedByPosition = var3;
        }

        public void invalidateTickCache() {
            this.cachedTickValue = null;
            ++this.cacheTickId;
        }

        public Value getDimensionValue() {
            if (this.cachedTickValue != null) {
                return this.cachedTickValue;
            }
            Value var0 = this.computeValueNotPositional();
            this.cachedTickValue = var0;
            return var0;
        }

        public Value getValue(Vec3D var0, @Nullable SpatialAttributeInterpolator var1) {
            if (!this.isAffectedByPosition) {
                return this.getDimensionValue();
            }
            return this.computeValuePositional(var0, var1);
        }

        private Value computeValuePositional(Vec3D var0, @Nullable SpatialAttributeInterpolator var1) {
            Value var2 = this.baseValue;
            for (EnvironmentAttributeLayer<Value> var4 : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer;
                Objects.requireNonNull(var4);
                int n2 = 0;
                var2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.a.class, EnvironmentAttributeLayer.c.class, EnvironmentAttributeLayer.b.class}, environmentAttributeLayer, n2)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        EnvironmentAttributeLayer.a var7 = (EnvironmentAttributeLayer.a)environmentAttributeLayer;
                        yield var7.applyConstant(var2);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.c var8 = (EnvironmentAttributeLayer.c)environmentAttributeLayer;
                        yield var8.applyTimeBased(var2, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.b var9 = (EnvironmentAttributeLayer.b)environmentAttributeLayer;
                        yield var9.applyPositional(var2, Objects.requireNonNull(var0), var1);
                    }
                };
            }
            return this.attribute.sanitizeValue(var2);
        }

        private Value computeValueNotPositional() {
            Value var0 = this.baseValue;
            for (EnvironmentAttributeLayer<Value> var2 : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer;
                Objects.requireNonNull(var2);
                int n2 = 0;
                var0 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.a.class, EnvironmentAttributeLayer.c.class, EnvironmentAttributeLayer.b.class}, environmentAttributeLayer, n2)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        EnvironmentAttributeLayer.a var5 = (EnvironmentAttributeLayer.a)environmentAttributeLayer;
                        yield var5.applyConstant(var0);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.c var6 = (EnvironmentAttributeLayer.c)environmentAttributeLayer;
                        yield var6.applyTimeBased(var0, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.b var7 = (EnvironmentAttributeLayer.b)environmentAttributeLayer;
                        yield var0;
                    }
                };
            }
            return this.attribute.sanitizeValue(var0);
        }
    }

    public static class a {
        private final Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> layersByAttribute = new HashMap();

        a() {
        }

        public a addDefaultLayers(World var0) {
            EnvironmentAttributeSystem.addDefaultLayers(this, var0);
            return this;
        }

        public a addConstantLayer(EnvironmentAttributeMap var0) {
            for (EnvironmentAttribute<?> var2 : var0.keySet()) {
                this.addConstantEntry(var2, var0);
            }
            return this;
        }

        private <Value> a addConstantEntry(EnvironmentAttribute<Value> var0, EnvironmentAttributeMap var1) {
            EnvironmentAttributeMap.b<Value, ?> var2 = var1.get(var0);
            if (var2 == null) {
                throw new IllegalArgumentException("Missing attribute " + String.valueOf(var0));
            }
            return this.addConstantLayer(var0, var2::applyModifier);
        }

        public <Value> a addConstantLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.a<Value> var1) {
            return this.addLayer(var0, var1);
        }

        public <Value> a addTimeBasedLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.c<Value> var1) {
            return this.addLayer(var0, var1);
        }

        public <Value> a addPositionalLayer(EnvironmentAttribute<Value> var0, EnvironmentAttributeLayer.b<Value> var1) {
            return this.addLayer(var0, var1);
        }

        private <Value> a addLayer(EnvironmentAttribute<Value> var02, EnvironmentAttributeLayer<Value> var1) {
            this.layersByAttribute.computeIfAbsent(var02, var0 -> new ArrayList()).add(var1);
            return this;
        }

        public a addTimelineLayer(Holder<Timeline> var0, LongSupplier var1) {
            for (EnvironmentAttribute<?> var3 : var0.value().attributes()) {
                this.addTimelineLayerForAttribute(var0, var3, var1);
            }
            return this;
        }

        private <Value> void addTimelineLayerForAttribute(Holder<Timeline> var0, EnvironmentAttribute<Value> var1, LongSupplier var2) {
            this.addTimeBasedLayer(var1, var0.value().createTrackSampler(var1, var2));
        }

        public EnvironmentAttributeSystem build() {
            return new EnvironmentAttributeSystem(this.layersByAttribute);
        }
    }
}

