/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEffect;

public record BackgroundMusic(Optional<Music> defaultMusic, Optional<Music> creativeMusic, Optional<Music> underwaterMusic) {
    public static final BackgroundMusic EMPTY = new BackgroundMusic(Optional.empty(), Optional.empty(), Optional.empty());
    public static final BackgroundMusic OVERWORLD = new BackgroundMusic(Optional.of(Musics.GAME), Optional.of(Musics.CREATIVE), Optional.empty());
    public static final Codec<BackgroundMusic> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Music.CODEC.optionalFieldOf("default").forGetter(BackgroundMusic::defaultMusic), (App)Music.CODEC.optionalFieldOf("creative").forGetter(BackgroundMusic::creativeMusic), (App)Music.CODEC.optionalFieldOf("underwater").forGetter(BackgroundMusic::underwaterMusic)).apply((Applicative)var0, BackgroundMusic::new));

    public BackgroundMusic(Music var0) {
        this(Optional.of(var0), Optional.empty(), Optional.empty());
    }

    public BackgroundMusic(Holder<SoundEffect> var0) {
        this(Musics.createGameMusic(var0));
    }

    public BackgroundMusic withUnderwater(Music var0) {
        return new BackgroundMusic(this.defaultMusic, this.creativeMusic, Optional.of(var0));
    }

    public Optional<Music> select(boolean var0, boolean var1) {
        if (var1 && this.underwaterMusic.isPresent()) {
            return this.underwaterMusic;
        }
        if (var0 && this.creativeMusic.isPresent()) {
            return this.creativeMusic;
        }
        return this.defaultMusic;
    }
}

