/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.util.function.LongSupplier;
import net.minecraft.SharedConstants;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerFillerActive;
import net.minecraft.util.profiling.MethodProfiler;
import net.minecraft.util.profiling.MethodProfilerResults;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class GameProfilerTick {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final LongSupplier realTime;
    private final long saveThreshold;
    private int tick;
    private final File location;
    private GameProfilerFillerActive profiler = GameProfilerDisabled.INSTANCE;

    public GameProfilerTick(LongSupplier var0, String var1, long var2) {
        this.realTime = var0;
        this.location = new File("debug", var1);
        this.saveThreshold = var2;
    }

    public GameProfilerFiller startTick() {
        this.profiler = new MethodProfiler(this.realTime, () -> this.tick, () -> true);
        ++this.tick;
        return this.profiler;
    }

    public void endTick() {
        if (this.profiler == GameProfilerDisabled.INSTANCE) {
            return;
        }
        MethodProfilerResults var0 = this.profiler.getResults();
        this.profiler = GameProfilerDisabled.INSTANCE;
        if (var0.getNanoDuration() >= this.saveThreshold) {
            File var1 = new File(this.location, "tick-results-" + SystemUtils.getFilenameFormattedDateTime() + ".txt");
            var0.saveResults(var1.toPath());
            LOGGER.info("Recorded long tick -- wrote info to: {}", (Object)var1.getAbsolutePath());
        }
    }

    public static @Nullable GameProfilerTick createTickProfiler(String var0) {
        if (SharedConstants.DEBUG_MONITOR_TICK_TIMES) {
            return new GameProfilerTick(SystemUtils.timeSource, var0, SharedConstants.MAXIMUM_TICK_TIME_NANOS);
        }
        return null;
    }

    public static GameProfilerFiller decorateFiller(GameProfilerFiller var0, @Nullable GameProfilerTick var1) {
        if (var1 != null) {
            return GameProfilerFiller.combine(var1.startTick(), var0);
        }
        return var0;
    }
}

