/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import org.jspecify.annotations.Nullable;

public class Dictionary<S> {
    private final Map<Atom<?>, a<S, ?>> terms = new IdentityHashMap();

    public <T> NamedRule<S, T> put(Atom<T> var0, Rule<S, T> var1) {
        a var2 = this.terms.computeIfAbsent(var0, a::new);
        if (var2.value != null) {
            throw new IllegalArgumentException("Trying to override rule: " + String.valueOf(var0));
        }
        var2.value = var1;
        return var2;
    }

    public <T> NamedRule<S, T> putComplex(Atom<T> var0, Term<S> var1, Rule.a<S, T> var2) {
        return this.put(var0, Rule.fromTerm(var1, var2));
    }

    public <T> NamedRule<S, T> put(Atom<T> var0, Term<S> var1, Rule.b<S, T> var2) {
        return this.put(var0, Rule.fromTerm(var1, var2));
    }

    public void checkAllBound() {
        List<Atom> var02 = this.terms.entrySet().stream().filter(var0 -> ((a)var0.getValue()).value == null).map(Map.Entry::getKey).toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound names: " + String.valueOf(var02));
        }
    }

    public <T> NamedRule<S, T> getOrThrow(Atom<T> var0) {
        return Objects.requireNonNull(this.terms.get(var0), () -> "No rule called " + String.valueOf(var0));
    }

    public <T> NamedRule<S, T> forward(Atom<T> var0) {
        return this.getOrCreateEntry(var0);
    }

    private <T> a<S, T> getOrCreateEntry(Atom<T> var0) {
        return this.terms.computeIfAbsent(var0, a::new);
    }

    public <T> Term<S> named(Atom<T> var0) {
        return new b<S, T>(this.getOrCreateEntry(var0), var0);
    }

    public <T> Term<S> namedWithAlias(Atom<T> var0, Atom<T> var1) {
        return new b<S, T>(this.getOrCreateEntry(var0), var1);
    }

    static class a<S, T>
    implements NamedRule<S, T>,
    Supplier<String> {
        private final Atom<T> name;
        @Nullable Rule<S, T> value;

        private a(Atom<T> var0) {
            this.name = var0;
        }

        @Override
        public Atom<T> name() {
            return this.name;
        }

        @Override
        public Rule<S, T> value() {
            return Objects.requireNonNull(this.value, this);
        }

        @Override
        public String get() {
            return "Unbound rule " + String.valueOf(this.name);
        }

        @Override
        public /* synthetic */ Object get() {
            return this.get();
        }
    }

    record b<S, T>(a<S, T> ruleToParse, Atom<T> nameToStore) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> var0, Scope var1, Control var2) {
            T var3 = var0.parse(this.ruleToParse);
            if (var3 == null) {
                return false;
            }
            var1.put(this.nameToStore, var3);
            return true;
        }
    }
}

