/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDebugBlockValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugChunkValuePacket;
import net.minecraft.network.protocol.game.ClientboundDebugEntityValuePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Unit;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.util.debug.DebugSubscription;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.jspecify.annotations.Nullable;

public abstract class TrackingDebugSynchronizer<T> {
    protected final DebugSubscription<T> subscription;
    private final Set<UUID> subscribedPlayers = new ObjectOpenHashSet();

    public TrackingDebugSynchronizer(DebugSubscription<T> var0) {
        this.subscription = var0;
    }

    public final void tick(WorldServer var0) {
        for (EntityPlayer var2 : var0.players()) {
            boolean var3 = this.subscribedPlayers.contains(var2.getUUID());
            boolean var4 = var2.debugSubscriptions().contains(this.subscription);
            if (var4 == var3) continue;
            if (var4) {
                this.addSubscriber(var2);
                continue;
            }
            this.subscribedPlayers.remove(var2.getUUID());
        }
        this.subscribedPlayers.removeIf(var1 -> var0.getPlayerByUUID((UUID)var1) == null);
        if (!this.subscribedPlayers.isEmpty()) {
            this.pollAndSendUpdates(var0);
        }
    }

    private void addSubscriber(EntityPlayer var0) {
        this.subscribedPlayers.add(var0.getUUID());
        var0.getChunkTrackingView().forEach(var1 -> {
            if (!var0.connection.chunkSender.isPending(var1.toLong())) {
                this.startTrackingChunk(var0, (ChunkCoordIntPair)var1);
            }
        });
        var0.level().getChunkSource().chunkMap.forEachEntityTrackedBy(var0, var1 -> this.startTrackingEntity(var0, (Entity)var1));
    }

    protected final void sendToPlayersTrackingChunk(WorldServer var0, ChunkCoordIntPair var1, Packet<? super PacketListenerPlayOut> var2) {
        PlayerChunkMap var3 = var0.getChunkSource().chunkMap;
        for (UUID var5 : this.subscribedPlayers) {
            EntityPlayer var6;
            EntityHuman entityHuman = var0.getPlayerByUUID(var5);
            if (!(entityHuman instanceof EntityPlayer) || !var3.isChunkTracked(var6 = (EntityPlayer)entityHuman, var1.x, var1.z)) continue;
            var6.connection.send(var2);
        }
    }

    protected final void sendToPlayersTrackingEntity(WorldServer var02, Entity var1, Packet<? super PacketListenerPlayOut> var2) {
        PlayerChunkMap var3 = var02.getChunkSource().chunkMap;
        var3.sendToTrackingPlayersFiltered(var1, var2, var0 -> this.subscribedPlayers.contains(var0.getUUID()));
    }

    public final void startTrackingChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
        if (this.subscribedPlayers.contains(var0.getUUID())) {
            this.sendInitialChunk(var0, var1);
        }
    }

    public final void startTrackingEntity(EntityPlayer var0, Entity var1) {
        if (this.subscribedPlayers.contains(var0.getUUID())) {
            this.sendInitialEntity(var0, var1);
        }
    }

    protected void clear() {
    }

    protected void pollAndSendUpdates(WorldServer var0) {
    }

    protected void sendInitialChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
    }

    protected void sendInitialEntity(EntityPlayer var0, Entity var1) {
    }

    public static class d
    extends TrackingDebugSynchronizer<Unit> {
        public d() {
            super(DebugSubscriptions.VILLAGE_SECTIONS);
        }

        @Override
        protected void sendInitialChunk(EntityPlayer var02, ChunkCoordIntPair var1) {
            WorldServer var2 = var02.level();
            VillagePlace var3 = var2.getPoiManager();
            var3.getInChunk(var0 -> true, var1, VillagePlace.Occupancy.ANY).forEach(var22 -> {
                SectionPosition var3 = SectionPosition.of(var22.getPos());
                d.forEachVillageSectionUpdate(var2, var3, (var1, var2) -> {
                    BlockPosition var3 = var1.center();
                    var0.connection.send(new ClientboundDebugBlockValuePacket(var3, this.subscription.packUpdate(var2 != false ? Unit.INSTANCE : null)));
                });
            });
        }

        public void onPoiAdded(WorldServer var0, VillagePlaceRecord var1) {
            this.sendVillageSectionsPacket(var0, var1.getPos());
        }

        public void onPoiRemoved(WorldServer var0, BlockPosition var1) {
            this.sendVillageSectionsPacket(var0, var1);
        }

        private void sendVillageSectionsPacket(WorldServer var0, BlockPosition var12) {
            d.forEachVillageSectionUpdate(var0, SectionPosition.of(var12), (var1, var2) -> {
                BlockPosition var3 = var1.center();
                if (var2.booleanValue()) {
                    this.sendToPlayersTrackingChunk(var0, new ChunkCoordIntPair(var3), new ClientboundDebugBlockValuePacket(var3, this.subscription.packUpdate(Unit.INSTANCE)));
                } else {
                    this.sendToPlayersTrackingChunk(var0, new ChunkCoordIntPair(var3), new ClientboundDebugBlockValuePacket(var3, this.subscription.emptyUpdate()));
                }
            });
        }

        private static void forEachVillageSectionUpdate(WorldServer var0, SectionPosition var1, BiConsumer<SectionPosition, Boolean> var2) {
            for (int var3 = -1; var3 <= 1; ++var3) {
                for (int var4 = -1; var4 <= 1; ++var4) {
                    for (int var5 = -1; var5 <= 1; ++var5) {
                        SectionPosition var6 = var1.offset(var4, var5, var3);
                        if (var0.isVillage(var6.center())) {
                            var2.accept(var6, true);
                            continue;
                        }
                        var2.accept(var6, false);
                    }
                }
            }
        }
    }

    public static class a
    extends TrackingDebugSynchronizer<DebugPoiInfo> {
        public a() {
            super(DebugSubscriptions.POIS);
        }

        @Override
        protected void sendInitialChunk(EntityPlayer var02, ChunkCoordIntPair var12) {
            WorldServer var2 = var02.level();
            VillagePlace var3 = var2.getPoiManager();
            var3.getInChunk(var0 -> true, var12, VillagePlace.Occupancy.ANY).forEach(var1 -> var0.connection.send(new ClientboundDebugBlockValuePacket(var1.getPos(), this.subscription.packUpdate(new DebugPoiInfo((VillagePlaceRecord)var1)))));
        }

        public void onPoiAdded(WorldServer var0, VillagePlaceRecord var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkCoordIntPair(var1.getPos()), new ClientboundDebugBlockValuePacket(var1.getPos(), this.subscription.packUpdate(new DebugPoiInfo(var1))));
        }

        public void onPoiRemoved(WorldServer var0, BlockPosition var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkCoordIntPair(var1), new ClientboundDebugBlockValuePacket(var1, this.subscription.emptyUpdate()));
        }

        public void onPoiTicketCountChanged(WorldServer var0, BlockPosition var1) {
            this.sendToPlayersTrackingChunk(var0, new ChunkCoordIntPair(var1), new ClientboundDebugBlockValuePacket(var1, this.subscription.packUpdate(var0.getPoiManager().getDebugPoiInfo(var1))));
        }
    }

    static class c<T> {
        private final DebugValueSource.b<T> getter;
        @Nullable T lastSyncedValue;

        c(DebugValueSource.b<T> var0) {
            this.getter = var0;
        }

        public @Nullable DebugSubscription.b<T> pollUpdate(DebugSubscription<T> var0) {
            T var1 = this.getter.get();
            if (!Objects.equals(var1, this.lastSyncedValue)) {
                this.lastSyncedValue = var1;
                return var0.packUpdate(var1);
            }
            return null;
        }
    }

    public static class b<T>
    extends TrackingDebugSynchronizer<T> {
        private final Map<ChunkCoordIntPair, c<T>> chunkSources = new HashMap<ChunkCoordIntPair, c<T>>();
        private final Map<BlockPosition, c<T>> blockEntitySources = new HashMap<BlockPosition, c<T>>();
        private final Map<UUID, c<T>> entitySources = new HashMap<UUID, c<T>>();

        public b(DebugSubscription<T> var0) {
            super(var0);
        }

        @Override
        protected void clear() {
            this.chunkSources.clear();
            this.blockEntitySources.clear();
            this.entitySources.clear();
        }

        @Override
        protected void pollAndSendUpdates(WorldServer var0) {
            Object var4;
            DebugSubscription.b<T> var3;
            for (Map.Entry<ChunkCoordIntPair, c<T>> entry : this.chunkSources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = entry.getKey();
                this.sendToPlayersTrackingChunk(var0, (ChunkCoordIntPair)var4, new ClientboundDebugChunkValuePacket((ChunkCoordIntPair)var4, var3));
            }
            for (Map.Entry<Object, c<T>> entry : this.blockEntitySources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = (BlockPosition)entry.getKey();
                ChunkCoordIntPair var5 = new ChunkCoordIntPair((BlockPosition)var4);
                this.sendToPlayersTrackingChunk(var0, var5, new ClientboundDebugBlockValuePacket((BlockPosition)var4, var3));
            }
            for (Map.Entry<Object, c<T>> entry : this.entitySources.entrySet()) {
                var3 = entry.getValue().pollUpdate(this.subscription);
                if (var3 == null) continue;
                var4 = Objects.requireNonNull(var0.getEntity((UUID)entry.getKey()));
                this.sendToPlayersTrackingEntity(var0, (Entity)var4, new ClientboundDebugEntityValuePacket(((Entity)var4).getId(), var3));
            }
        }

        public void registerChunk(ChunkCoordIntPair var0, DebugValueSource.b<T> var1) {
            this.chunkSources.put(var0, new c<T>(var1));
        }

        public void registerBlockEntity(BlockPosition var0, DebugValueSource.b<T> var1) {
            this.blockEntitySources.put(var0, new c<T>(var1));
        }

        public void registerEntity(UUID var0, DebugValueSource.b<T> var1) {
            this.entitySources.put(var0, new c<T>(var1));
        }

        public void dropChunk(ChunkCoordIntPair var0) {
            this.chunkSources.remove(var0);
            this.blockEntitySources.keySet().removeIf(var0::contains);
        }

        public void dropBlockEntity(WorldServer var0, BlockPosition var1) {
            c<T> var2 = this.blockEntitySources.remove(var1);
            if (var2 != null) {
                ChunkCoordIntPair var3 = new ChunkCoordIntPair(var1);
                this.sendToPlayersTrackingChunk(var0, var3, new ClientboundDebugBlockValuePacket(var1, this.subscription.emptyUpdate()));
            }
        }

        public void dropEntity(Entity var0) {
            this.entitySources.remove(var0.getUUID());
        }

        @Override
        protected void sendInitialChunk(EntityPlayer var0, ChunkCoordIntPair var1) {
            c<T> var2 = this.chunkSources.get(var1);
            if (var2 != null && var2.lastSyncedValue != null) {
                var0.connection.send(new ClientboundDebugChunkValuePacket(var1, this.subscription.packUpdate(var2.lastSyncedValue)));
            }
            for (Map.Entry<BlockPosition, c<T>> var4 : this.blockEntitySources.entrySet()) {
                BlockPosition var6;
                Object var5 = var4.getValue().lastSyncedValue;
                if (var5 == null || !var1.contains(var6 = var4.getKey())) continue;
                var0.connection.send(new ClientboundDebugBlockValuePacket(var6, this.subscription.packUpdate(var5)));
            }
        }

        @Override
        protected void sendInitialEntity(EntityPlayer var0, Entity var1) {
            c<T> var2 = this.entitySources.get(var1.getUUID());
            if (var2 != null && var2.lastSyncedValue != null) {
                var0.connection.send(new ClientboundDebugEntityValuePacket(var1.getId(), this.subscription.packUpdate(var2.lastSyncedValue)));
            }
        }
    }
}

