/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Deque;
import org.jspecify.annotations.Nullable;

public final class SequencedPriorityIterator<T>
extends AbstractIterator<T> {
    private static final int MIN_PRIO = Integer.MIN_VALUE;
    private @Nullable Deque<T> highestPrioQueue = null;
    private int highestPrio = Integer.MIN_VALUE;
    private final Int2ObjectMap<Deque<T>> queuesByPriority = new Int2ObjectOpenHashMap();

    public void add(T var02, int var1) {
        if (var1 == this.highestPrio && this.highestPrioQueue != null) {
            this.highestPrioQueue.addLast(var02);
            return;
        }
        Deque var2 = (Deque)this.queuesByPriority.computeIfAbsent(var1, var0 -> Queues.newArrayDeque());
        var2.addLast(var02);
        if (var1 >= this.highestPrio) {
            this.highestPrioQueue = var2;
            this.highestPrio = var1;
        }
    }

    protected @Nullable T computeNext() {
        if (this.highestPrioQueue == null) {
            return (T)this.endOfData();
        }
        T var0 = this.highestPrioQueue.removeFirst();
        if (var0 == null) {
            return (T)this.endOfData();
        }
        if (this.highestPrioQueue.isEmpty()) {
            this.switchCacheToNextHighestPrioQueue();
        }
        return var0;
    }

    private void switchCacheToNextHighestPrioQueue() {
        int var0 = Integer.MIN_VALUE;
        Deque var1 = null;
        for (Int2ObjectMap.Entry var3 : Int2ObjectMaps.fastIterable(this.queuesByPriority)) {
            Deque var4 = (Deque)var3.getValue();
            int var5 = var3.getIntKey();
            if (var5 <= var0 || var4.isEmpty()) continue;
            var0 = var5;
            var1 = var4;
            if (var5 != this.highestPrio - 1) continue;
            break;
        }
        this.highestPrio = var0;
        this.highestPrioQueue = var1;
    }
}

